/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import java.io.IOException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.RestoreStorageDialog;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;


public class RestoreStorageAction extends SingleSelectionActionEx {
	private static class StorageDetail{
		public String volumeName;
	}
	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgRestoreStorageConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.restore"});
	private String msgRestoreStorageResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.restore"});


	@Override
	protected void invoke(IAction action) throws InvocationException {
		final ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		IRegion region = backup.getCloudStorageBackupManager().getRegion();
		
		final String regionName = region.getRegion();
		
		final CloudResourceProvider provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
		RestoreStorageDialog dialog = new RestoreStorageDialog(this.viewPart.getSite().getShell());
		
		dialog.setCloudInfoProvider(provider);
		
		dialog.setBehavior(new RestoreStorageDialog.IDialogBehavior(){

			@Override
			public void setProvider(CloudResourceProvider provider) {}

			@Override
			public void setupVolumeName(Text txtVolumeName) {
				ObjectMapper om = new ObjectMapper();
				ObjectReader or = om.reader(StorageDetail.class);
				
				StorageDetail storageDetail = null;
				try {
					storageDetail = or.readValue(backup.getBackupedData().getStorageDetail());
				} catch (IOException e) {
					e.printStackTrace();
				}
				if(storageDetail != null && storageDetail.volumeName != null){
					txtVolumeName.setText(storageDetail.volumeName);
				}
			}

			@Override
			public void setupZone(Combo cmbZone) {
				cmbZone.setEnabled(false);
				for(Zone zone: provider.getZones(regionName)){
					cmbZone.add(zone.getName());
					cmbZone.setData(zone.getName(), zone);
				}
				if(cmbZone.getItemCount() > 0){
					cmbZone.select(cmbZone.indexOf(backup.getBackupedData().getZone()));
				}
			}

			@Override
			public void setupSnapshotDetail(Text txtSnapshotId,	Text txtSnapshotName, Text txtDescription) {
				txtSnapshotId.setText(backup.getStorageBackupId());
				if(backup.getSnapshotName() != null){
					txtSnapshotName.setText(backup.getSnapshotName());
				}
				if(backup.getDescription() != null){
					txtDescription.setText(backup.getDescription());
				}
			}
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgRestoreStorageConfirm)){

				RestoreStorageDialog.DialogData output = dialog.getOutput();
				
				CreateStorageRequest request = new CreateStorageRequest();
				request.setZone(backup.getBackupedData().getZone());
//				request.setFlavor(output.getStorage());
				request.setStorageName(output.getName());
				request.setSnapshotId(backup.getStorageBackupId());
				// 以下のパラメータはダミー
				request.setStorageSize(0);
				request.setStorageDetail("");
				
				region.getCloudService(ICloudComputeService.class).getStorageManager().createCloudStorage(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgRestoreStorageResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)selection).getFirstElement();
		if(backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudStorageBackup.RestoreStatus.unavailable.name())){
			action.setEnabled(false);
		}
	}
}