/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.util.Messages;

public class SelectVMIDialog extends Dialog {
	public interface IInitializer{
		void setupOfficial(org.eclipse.swt.widgets.List securityGroups);
		void setupMyTemplates(org.eclipse.swt.widgets.List securityGroups);
	}
	
	private List<Template> officialVMs;
	private List<Template> myVMs;
	private Template output = null;

	private org.eclipse.swt.widgets.Table officials;
	private org.eclipse.swt.widgets.Table myTemplates;

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	private String strMyTemplate = messages.getString("word.my_template");
	private String strOfficial = messages.getString("word.official");
	private String strName = messages.getString("word.name");
	private String strDescription = messages.getString("word.description");
	private String strSelectVirtualMachineImageDialog = messages.getString("caption.select_virtual_machine_image_dialog");
	private String msgSelectListItem = messages.getString("message.select_list_item");
	

	private TabFolder tabFolder;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public SelectVMIDialog(List<Template> officialVMs, List<Template> myVMs, Shell parentShell) {
		super(parentShell);
		this.officialVMs = officialVMs;
		this.myVMs = myVMs;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 465;
		container.setLayoutData(gd_container);

		GridLayout gl_container = new GridLayout(1, false);
		gl_container.marginTop = 10;
		gl_container.verticalSpacing = 10;
		container.setLayout(gl_container);
		
		tabFolder = new TabFolder(container, SWT.NONE);
		GridData gd_tabFolder = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_tabFolder.widthHint = 438;
		gd_tabFolder.heightHint = 222;
		tabFolder.setLayoutData(gd_tabFolder);
		
		TabItem tbtmcaptiontitleseparator = new TabItem(tabFolder, SWT.NONE);
		tbtmcaptiontitleseparator.setText(strOfficial);
		
		officials = new org.eclipse.swt.widgets.Table(tabFolder, SWT.BORDER | SWT.FULL_SELECTION);
		officials.setLinesVisible(true);
		officials.setHeaderVisible(true);
		tbtmcaptiontitleseparator.setControl(officials);
		
		TableColumn tableColumn = new TableColumn(officials, SWT.NONE);
		tableColumn.setWidth(180);
		tableColumn.setText(strName);
		
		TableColumn tableColumn_1 = new TableColumn(officials, SWT.NONE);
		tableColumn_1.setWidth(260);
		tableColumn_1.setText(strDescription);
		officials.select(0);
		
		TabItem tbtmcaptiontitleseparator_1 = new TabItem(tabFolder, SWT.NONE);
		tbtmcaptiontitleseparator_1.setText(strMyTemplate);
		
		myTemplates = new org.eclipse.swt.widgets.Table(tabFolder, SWT.BORDER | SWT.FULL_SELECTION);
		myTemplates.setLinesVisible(true);
		myTemplates.setHeaderVisible(true);
		tbtmcaptiontitleseparator_1.setControl(myTemplates);
		
		TableColumn tblclmnNewColumn = new TableColumn(myTemplates, SWT.NONE);
		tblclmnNewColumn.setWidth(180);
		tblclmnNewColumn.setText(strName);
		
		TableColumn tableColumn_2 = new TableColumn(myTemplates, SWT.NONE);
		tableColumn_2.setWidth(260);
		tableColumn_2.setText(strDescription);
		myTemplates.select(0);
		
		//　項目初期化
		{
			for (Template template: officialVMs) {
				TableItem item = new TableItem(officials, SWT.NONE);
				item.setText(template.getName());
				item.setText(1, template.getDiscription());
				item.setData(template);
			}
			for (Template template: myVMs) {
				TableItem item = new TableItem(myTemplates, SWT.NONE);
				item.setText(template.getName());
				item.setText(1, template.getDiscription());
				item.setData(template);
			}
		}

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(524, 437);
	}
	
	@Override
	protected void okPressed() {
		TabItem[] ts = tabFolder.getSelection();
		org.eclipse.swt.widgets.Table l = (org.eclipse.swt.widgets.Table)ts[0].getControl();
		TableItem[] vm = l.getSelection();
		if (vm == null || vm.length == 0) {
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgSelectListItem);
			return;
		}
		
		output = (Template)vm[0].getData();
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strSelectVirtualMachineImageDialog);
	}

	public Template getOutput() {
		return output;
	}
}
