/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;

public class AttachStorageFromInstanceDialog extends Dialog {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strZone = messages.getString("word.zone");
	private String strInstance = messages.getString("word.instance");
	private String strDevice = messages.getString("word.device");
	private String strVolumeId = messages.getString("word.volume_id");
	private String strVolumeName = messages.getString("word.volume_name");
	private String strSnapshotId = messages.getString("word.snapshot_id");
	private String strSize = messages.getString("word.size");
	private String strStorageType = messages.getString("word.storage_type");
	private String strAttachStorageDialog = messages.getString("caption.attach_storage_dialog");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");

	private ICloudInstance instance;
	private Table table;
	private TableViewer tableViewer;
	private Text zone;
	private Text instanceName;
//	private Text device;

	private String storageId;
//	private String deviceName;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AttachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
		super(parentShell);
		this.instance = instance;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblZone = new Label(container, SWT.NONE);
		lblZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblZone.setText(strZone + strSeparator);
		
		zone = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		zone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		zone.setText(instance.getZone());
		
		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(strInstance + strSeparator);
		
		instanceName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		instanceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		instanceName.setText(instance.getInstanceId());
		
//		Label lblDevice = new Label(container, SWT.NONE);
//		lblDevice.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
//		lblDevice.setText(strDevice);
		
		instance.update();
//		device = new Text(container, SWT.BORDER);
//		device.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		TableColumn tblclmnVolumeId = new TableColumn(table, SWT.NONE);
		tblclmnVolumeId.setWidth(90);
		tblclmnVolumeId.setText(strVolumeId);

		TableColumn tableColumn_6 = new TableColumn(table, SWT.NONE);
		tableColumn_6.setWidth(70);
		tableColumn_6.setText(strVolumeName);
		
		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(70);
		tableColumn_1.setText(strDevice);
		
		TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);
		tableColumn_2.setWidth(70);
		tableColumn_2.setText(strSnapshotId);
		
		TableColumn tableColumn_3 = new TableColumn(table, SWT.NONE);
		tableColumn_3.setWidth(70);
		tableColumn_3.setText(strSize);
		
		TableColumn tableColumn_4 = new TableColumn(table, SWT.NONE);
		tableColumn_4.setWidth(70);
		tableColumn_4.setText(strStorageType);
		
		instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().update();
		List<ICloudStorage> availableVolumes = new ArrayList<ICloudStorage>(Arrays.asList(instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().getCloudStorages()));
		Iterator<ICloudStorage> itav = availableVolumes.iterator();
		while (itav.hasNext()){
			ICloudStorage storage = itav.next();
			if (storage.getStorageAttachment() != null || !(instance.getZone().equals(storage.getZone())) || storage.getRegistState().equals(ICloudStorage.RegistStateType.deleted.name())){
				itav.remove();
			}
		}
		
		tableViewer = new TableViewer(table);
		VolumeProvider vp = new VolumeProvider();
		tableViewer.setContentProvider(vp.getVolumeContentProvider());
		tableViewer.setInput(availableVolumes);
		tableViewer.setLabelProvider(vp.getVolumeLabelProvider());
		table.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				storageId = ((ICloudStorage)e.item.getData()).getStorageId();
			}
		});
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
//		deviceName = device.getText();
		if(this.storageId == null/* || this.deviceName == null || "".equals(this.deviceName)*/){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}		

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strAttachStorageDialog);
	}

	public String getStorageId(){
		return storageId;
	}

//	public String getDeviceName() {
//		return deviceName;
//	}
	
	public static class VolumeProvider {
		private VolumeContentProvider vcp;
		private VolumeLabelProvider vlp;
		
		public VolumeProvider(){
			this.vcp = new VolumeContentProvider();
			this.vlp = new VolumeLabelProvider();
		}
		
		public class VolumeContentProvider implements IStructuredContentProvider {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
			}
		}
		
		public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				ICloudStorage storage = (ICloudStorage)element;
				switch(columnIndex) {
					case 0:
						return storage.getStorageId();
					case 1:
						return storage.getStorageName();
					case 2:
						return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
					case 3:
						return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
					case 4:
						return storage.getSize() != null ? String.valueOf(storage.getSize()): "";
					case 5:
						return storage.getFlavor();
					}
				return null;
			}
			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		}
	
		public VolumeContentProvider getVolumeContentProvider(){
			return this.vcp;
		}
	
		public VolumeLabelProvider getVolumeLabelProvider(){
			return this.vlp;
		}
	}
}
