/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class BackupInstanceDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strInstanceId = this.messages.getString("word.instance_id");
    private String strImageName = this.messages.getString("word.image_name");
    private String strDescription = this.messages.getString("word.description");
    private String strWithAdditionalVolume = this.messages.getString("caption.with_additional_volume");
    private String strBackupInstanceDialog = this.messages.getString("caption.backup_instance_dialog");
    private ICloudInstance instance;
    @RequiredInput(value="strImageName")
    private Text txtImageName;
    private Text txtImageDescription;
    private Text txtInstanceId;
    private Button btnWithAdditionalVolume;
    private String imageName;
    private String imageDescription;
    private Boolean withAdditionalVolume;

    public BackupInstanceDialog(Shell parentShell, ICloudInstance instance) {
        super(parentShell);
        this.instance = instance;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.horizontalSpacing = 16;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblInstanceId = new Label(container, 0);
        lblInstanceId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstanceId.setText(this.strInstanceId + this.strSeparator);
        this.txtInstanceId = new Text(container, 2056);
        this.txtInstanceId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        new Label(container, 0);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(this.strImageName + this.strSeparator);
        this.txtImageName = new Text(container, 2048);
        GridData gd_name = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_name.widthHint = 203;
        this.txtImageName.setLayoutData((Object)gd_name);
        new Label(container, 0);
        new Label(container, 0);
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.strDescription + this.strSeparator);
        this.txtImageDescription = new Text(container, 2048);
        GridData gd_Description = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_Description.widthHint = 146;
        this.txtImageDescription.setLayoutData((Object)gd_Description);
        this.txtInstanceId.setText(this.instance.getInstanceId());
        new Label(container, 0);
        new Label(container, 0);
        Label lblWithEbsVolume = new Label(container, 0);
        lblWithEbsVolume.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblWithEbsVolume.setText(this.strWithAdditionalVolume + this.strSeparator);
        this.btnWithAdditionalVolume = new Button(container, 32);
        ControlUtil.setRequired((Control[])new Control[]{this.txtImageName});
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        try {
            ControlUtil.validate((Dialog)this);
        }
        catch (ValidateException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.imageName = this.txtImageName.getText();
        this.imageDescription = this.txtImageDescription.getText();
        this.withAdditionalVolume = this.btnWithAdditionalVolume.getSelection();
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strBackupInstanceDialog);
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getDescription() {
        return this.imageDescription;
    }

    public Boolean getWithEBSVolume() {
        return this.withAdditionalVolume;
    }
}

