/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.presenter;

import com.clustercontrol.cloud.cloudn.base.Activator;
import com.clustercontrol.cloud.cloudn.base.commons.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.ShowPasswordDialog;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloudn.AttachStorageResult;
import com.clustercontrol.ws.cloudn.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpoint;
import com.clustercontrol.ws.cloudn.DeleteInstanceResult;
import com.clustercontrol.ws.cloudn.InvalidRole_Exception;
import com.clustercontrol.ws.cloudn.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloudn.JobResult;
import com.clustercontrol.ws.cloudn.JobStatus;
import com.clustercontrol.ws.cloudn.PasswordResult;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class JobTrackingService {
    private static ExecutorService service = Executors.newFixedThreadPool(5);
    private static MessageManagerExt messages = MessageManagerExt.getInstance("messages");

    public static void trackPassword(final IViewPart view, final ICloudInstance instance) {
        JobTrackingService.trackJob(new GetResultAction<PasswordResult>(){

            @Override
            public PasswordResult getResult() {
                try {
                    return ((CloudnOptionEndpoint)Activator.getEndpointManager().getEndpoint(CloudnOptionEndpoint.class)).getPassword(AccountControlUtil.getRoleId((String)instance.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceId()), instance.getRegion(), instance.getInstanceId());
                }
                catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
                    PasswordResult result = new PasswordResult();
                    result.setStatus(JobStatus.ERROR);
                    if (e instanceof CloudManagerFault_Exception && ((CloudManagerFault_Exception)e).getFaultInfo().getErrorCode().equals("JOB_ID_UNREGISTERED")) {
                        result.setErrorText(messages.getString("message.error.password_is_fixed_and_unreferable"));
                    } else {
                        result.setErrorText(e.getMessage());
                    }
                    return result;
                }
            }
        }, new AfterAction<PasswordResult>(){

            @Override
            public boolean invoke(PasswordResult result) {
                String tmpText = null;
                switch (result.getStatus()) {
                    case RUNNING: {
                        return false;
                    }
                    case SUCCESS: {
                        tmpText = result.getPassword();
                        break;
                    }
                    default: {
                        tmpText = messages.getString("message.error.track_password_failed");
                        if (result.getErrorCode() != null) {
                            tmpText = tmpText + "\nerror code : " + result.getErrorCode();
                        }
                        if (result.getErrorText() == null || result.getErrorText().isEmpty()) break;
                        tmpText = tmpText + "\nerror message : " + result.getErrorText();
                    }
                }
                final String displayText = tmpText;
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ShowPasswordDialog dialog = new ShowPasswordDialog(view.getSite().getShell());
                        dialog.setText(displayText);
                        dialog.setInstance(instance);
                        dialog.open();
                    }
                });
                return true;
            }
        });
    }

    public static void trackDeleteInstance(IViewPart view, final ICloudInstance instance) {
        String errorMessage = messages.getString("message.error.delete_instance_failed") + "\nInstanceId : " + instance.getInstanceId();
        JobTrackingService.trackJobResult(view, new GetResultAction<DeleteInstanceResult>(){

            @Override
            public DeleteInstanceResult getResult() {
                try {
                    return ((CloudnOptionEndpoint)Activator.getEndpointManager().getEndpoint(CloudnOptionEndpoint.class)).getDeleteInstanceResult(AccountControlUtil.getRoleId((String)instance.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceId()), instance.getRegion(), instance.getInstanceId());
                }
                catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
                    DeleteInstanceResult result = new DeleteInstanceResult();
                    result.setStatus(JobStatus.ERROR);
                    result.setErrorText(e.getMessage());
                    return result;
                }
            }
        }, errorMessage);
    }

    public static void trackAttachStorage(IViewPart view, ICloudStorage storage, String instanceId) {
        JobTrackingService.trackAttachStorage(view, AccountControlUtil.getRoleId((String)storage.getCloudStorageManager().getRegion().getAccountResource().getAccountResourceId()), storage.getCloudStorageManager().getRegion().getRegion(), storage.getStorageId(), instanceId);
    }

    public static void trackAttachStorage(IViewPart view, ICloudInstance instance, String storageId) {
        JobTrackingService.trackAttachStorage(view, AccountControlUtil.getRoleId((String)instance.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceId()), instance.getCloudInstanceManager().getRegion().getRegion(), storageId, instance.getInstanceId());
    }

    public static void trackAttachStorage(IViewPart view, final String roleId, final String region, final String storageId, final String instanceId) {
        String errorMessage = messages.getString("message.error.attach_storage_failed") + "\nStorageId : " + storageId;
        JobTrackingService.trackJobResult(view, new GetResultAction<AttachStorageResult>(){

            @Override
            public AttachStorageResult getResult() {
                try {
                    return ((CloudnOptionEndpoint)Activator.getEndpointManager().getEndpoint(CloudnOptionEndpoint.class)).getAttachStorageResult(roleId, region, storageId, instanceId);
                }
                catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
                    AttachStorageResult result = new AttachStorageResult();
                    result.setStatus(JobStatus.ERROR);
                    result.setErrorText(e.getMessage());
                    return result;
                }
            }
        }, errorMessage);
    }

    public static <T extends JobResult> void trackJobResult(final IViewPart view, GetResultAction<T> action, final String errorMessage) {
        JobTrackingService.trackJob(action, new AfterAction<T>(){

            @Override
            public boolean invoke(T result) {
                String tmpText = null;
                switch (result.getStatus()) {
                    case RUNNING: {
                        return false;
                    }
                    case SUCCESS: {
                        return true;
                    }
                }
                tmpText = errorMessage;
                if (result.getErrorCode() != null) {
                    tmpText = tmpText + "\nerror code : " + result.getErrorCode();
                }
                if (result.getErrorText() != null && !result.getErrorText().isEmpty()) {
                    tmpText = tmpText + "\nerror message : " + result.getErrorText();
                }
                final String displayText = tmpText;
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)view.getSite().getShell(), (String)Messages.getString((String)"failed"), (String)displayText);
                    }
                });
                return true;
            }
        });
    }

    public static <T extends JobResult> void trackJob(final GetResultAction<T> getAction, final AfterAction<T> afterAction) {
        service.submit(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                boolean finish = false;
                while (true) {
                    try {
                        Object result = getAction.getResult();
                        finish = afterAction.invoke(result);
                        if (!finish && count >= CloudnConstants.JOB_TRACKING_COUNT) {
                            result.setStatus(JobStatus.ERROR);
                            result.setErrorCode("JOB_TRACKING_IS_TIMED_OUT");
                            result.setErrorText(messages.getString("message.error.job_tracking_is_timed_out"));
                            afterAction.invoke(result);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (finish || count >= CloudnConstants.JOB_TRACKING_COUNT) break;
                    try {
                        Thread.sleep(CloudnConstants.JOB_TRACKING_INTERVAL.intValue());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++count;
                }
            }
        });
    }

    public static interface AfterAction<T extends JobResult> {
        public boolean invoke(T var1);
    }

    public static interface GetResultAction<T extends JobResult> {
        public T getResult();
    }
}

