/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.CloudInstanceManager;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstanceManager;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeTree;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class InstancesView
extends FilterlingViewPartByScopeTree<ICloudInstanceManager, ICloudInstance, CloudInstance>
implements ISelectionListener {
    public static final String Id = InstancesView.class.getName();
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Label lblHeader;
    private FooterComposite footerComposite;
    private Table table;
    private TableViewer tableViewer;
    private ISelectionProvider provider = new ISelectionProvider(){
        private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        ISelection theSelection = StructuredSelection.EMPTY;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            return this.theSelection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.theSelection = selection;
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
            for (ISelectionChangedListener l : this.listeners) {
                l.selectionChanged(e);
            }
        }
    };

    public InstancesView() {
        LoginManager.login();
    }

    @Override
    protected void internalCreatePartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InstancesView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(InstancesView.this.tableViewer, column.getProvider()));
                }
            });
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList selection = new ArrayList();
                if (event.getSelection() instanceof IStructuredSelection) {
                    Iterator iter = ((IStructuredSelection)event.getSelection()).iterator();
                    while (iter.hasNext()) {
                        selection.add(iter.next());
                    }
                }
                InstancesView.this.provider.setSelection((ISelection)new StructuredSelection(selection.toArray()));
            }
        });
        this.getSite().setSelectionProvider(this.provider);
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view = InstancesView.this.getSite().getPage().findView("com.clustercontrol.cloud.ui.views.ScopeView");
                view.getSite().getPage().activate((IWorkbenchPart)view);
                view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
                InstancesView.this.getSite().getPage().activate((IWorkbenchPart)InstancesView.this);
            }
        });
        this.update();
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
    }

    @Override
    protected ICloudInstanceManager getRootElement(IAccountResource.IRegion region) {
        return region.getCloudService(ICloudComputeService.class).getInstanceManager();
    }

    @Override
    protected List<ICloudInstance> getElements(ICloudInstanceManager root) {
        return Arrays.asList(root.getCloudInstances());
    }

    @Override
    protected PropertyId2<CollectionObserver2<ICloudInstance>> getPropertyId() {
        return ICloudInstanceManager.p2.cloudInstances;
    }

    @Override
    protected boolean isMatchRegion(IAccountResource.IRegion region, ICloudInstance element) {
        return element.getCloudInstanceManager().getRegion() == region;
    }

    @Override
    protected boolean isMatchAvailabilityZone(String zoneName, ICloudInstance element) {
        return zoneName.equals(element.getZone());
    }

    @Override
    protected boolean isMatchFacilityId(String facilityId, ICloudInstance element) {
        return facilityId.equals(element.getFacilityId());
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected List<CloudInstance> getManagerElements(CloudEndpoint endpoint, IAccountResource.IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception {
        IAccountResource accountResource = region.getAccountResource();
        ICloudUser cloudUser = null;
        cloudUser = accountResource.getActiveUser();
        String roleId = cloudUser.getRoleId();
        String regionId = region.getRegion();
        return endpoint.getInstancesByRegion(roleId, regionId);
    }

    @Override
    protected void setManagerElements(ICloudInstanceManager rootElement, List<CloudInstance> ManagerElements) {
        ((CloudInstanceManager)rootElement).internalUpdate(ManagerElements);
    }

    @Override
    protected boolean isInitialized(ICloudInstanceManager rootElement) {
        return ((CloudInstanceManager)rootElement).isInitialized();
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    static /* synthetic */ MessageManager access$200() {
        return bundle_messages;
    }

    private static enum ViewColumn {
        facility_id(InstancesView.access$200().getString("word.facility_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getFacilityId();
            }
        }),
        facility_name(InstancesView.access$200().getString("word.facility_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getFacilityName();
            }
        }),
        instance_id(InstancesView.access$200().getString("word.instance_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getInstanceId();
            }
        }),
        instance_name(InstancesView.access$200().getString("word.instance_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getInstanceName();
            }
        }),
        platform(InstancesView.access$200().getString("word.platform"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getPlatform();
            }
        }),
        cloud_type_id(InstancesView.access$200().getString("word.cloud_type_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getCloudTypeId();
            }
        }),
        region(InstancesView.access$200().getString("word.region"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getCloudInstanceManager().getRegion().getRegionName();
            }
        }),
        zone(InstancesView.access$200().getString("word.zone"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getZone();
            }
        }),
        state(InstancesView.access$200().getString("word.state"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getState();
            }
        }),
        regist_state(InstancesView.access$200().getString("word.regist_state"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getRegistState();
            }
        }),
        type(InstancesView.access$200().getString("word.type"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getFlavor();
            }
        }),
        reg_user(InstancesView.access$200().getString("word.reg_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getRegUser();
            }
        }),
        reg_date(InstancesView.access$200().getString("word.reg_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudInstance)element).getRegDate() != null) {
                    return format.format(((ICloudInstance)element).getRegDate());
                }
                return "";
            }
        }),
        update_user(InstancesView.access$200().getString("word.update_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstance)element).getUpdateUser();
            }
        }),
        update_date(InstancesView.access$200().getString("word.update_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudInstance)element).getUpdateDate() != null) {
                    return format.format(((ICloudInstance)element).getUpdateDate());
                }
                return "";
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;
        private static SimpleDateFormat format;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }

        static {
            format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        }
    }
}

