/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.CloudInstanceBackupManager;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackupManager;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeAndAnother;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstanceBackup;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class InstanceBackupsView
extends FilterlingViewPartByScopeAndAnother<ICloudInstanceBackupManager, ICloudInstanceBackup, CloudInstanceBackup>
implements ISelectionListener {
    public static final String Id = "com.clustercontrol.cloud.ui.views.InstanceBackupsView";
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Label lblHeader;
    private FooterComposite footerComposite;
    private Table table;
    private TableViewer tableViewer;

    public InstanceBackupsView() {
        LoginManager.login();
    }

    @Override
    protected void internalCreatePartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InstanceBackupsView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(InstanceBackupsView.this.tableViewer, column.getProvider()));
                }
            });
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.update();
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view = InstanceBackupsView.this.getSite().getPage().findView("com.clustercontrol.cloud.ui.views.ScopeView");
                view.getSite().getPage().activate((IWorkbenchPart)view);
                view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
                InstanceBackupsView.this.getSite().getPage().activate((IWorkbenchPart)InstanceBackupsView.this);
            }
        });
    }

    @Override
    protected ICloudInstanceBackupManager getRootElement(IAccountResource.IRegion region) {
        return region.getCloudService(ICloudComputeService.class).getInstanceBackupManager();
    }

    @Override
    protected List<ICloudInstanceBackup> getElements(ICloudInstanceBackupManager root) {
        return Arrays.asList(root.getCloudInstanceBackups());
    }

    @Override
    protected PropertyId2<CollectionObserver2<ICloudInstanceBackup>> getPropertyId() {
        return ICloudInstanceBackupManager.p2.cloudInstanceBackups;
    }

    @Override
    protected boolean isMatchRegion(IAccountResource.IRegion region, ICloudInstanceBackup element) {
        return element.getCloudInstanceBackupManager().getRegion().equals(region);
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected List<CloudInstanceBackup> getManagerElements(CloudEndpoint endpoint, IAccountResource.IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception {
        return endpoint.getInstanceBackupsByRegion(region.getAccountResource().getActiveUser().getRoleId(), region.getRegion());
    }

    @Override
    protected void setManagerElements(ICloudInstanceBackupManager rootElement, List<CloudInstanceBackup> managerElements) {
        ((CloudInstanceBackupManager)rootElement).internalUpdate(managerElements);
    }

    @Override
    protected boolean isInitialized(ICloudInstanceBackupManager rootElement) {
        return ((CloudInstanceBackupManager)rootElement).isInitialized();
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }

    @Override
    protected String getHeaderByElementId(IAccountResource.IRegion region, List<String> elementIds) {
        if (!elementIds.isEmpty()) {
            return bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + bundle_messages.getString(region.getRegionName()) + " " + bundle_messages.getString("word.facility_id") + bundle_messages.getString("caption.title_separator") + elementIds.get(0);
        }
        return bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + bundle_messages.getString(region.getRegionName());
    }

    @Override
    protected String getElementId(Object selected) {
        if (selected instanceof ICloudInstance) {
            return ((ICloudInstance)selected).getFacilityId();
        }
        return null;
    }

    @Override
    protected boolean isMatchElementIds(List<String> elementIds, ICloudInstanceBackup element) {
        if (elementIds.isEmpty() || elementIds.size() > 1) {
            return false;
        }
        return element.getBackupedData().getFacilityId().equals(elementIds.get(0));
    }

    @Override
    protected String getSupportViewId() {
        return InstancesView.Id;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    static /* synthetic */ MessageManager access$100() {
        return bundle_messages;
    }

    private static enum ViewColumn {
        facility_id(InstanceBackupsView.access$100().getString("word.facility_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getBackupedData().getFacilityId();
            }
        }),
        reg_date(InstanceBackupsView.access$100().getString("word.create_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudInstanceBackup)element).getRegDate() != null) {
                    return format.format(((ICloudInstanceBackup)element).getRegDate());
                }
                return "";
            }
        }),
        image_id(InstanceBackupsView.access$100().getString("word.image_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getInstanceBackupId();
            }
        }),
        image_name(InstanceBackupsView.access$100().getString("word.image_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getName();
            }
        }),
        image_type(InstanceBackupsView.access$100().getString("word.image_type"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudInstanceBackup)element).getBackupedData() != null) {
                    return ((ICloudInstanceBackup)element).getBackupedData().getFlavor();
                }
                return "";
            }
        }),
        platform(InstanceBackupsView.access$100().getString("word.platform"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getPlatform();
            }
        }),
        cloud_type_id(InstanceBackupsView.access$100().getString("word.cloud_type_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getCloudTypeId();
            }
        }),
        description(InstanceBackupsView.access$100().getString("word.description"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getDescription();
            }
        }),
        exist_status(InstanceBackupsView.access$100().getString("word.exist_status"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getRestoreStatus();
            }
        }),
        region(InstanceBackupsView.access$100().getString("word.region"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getRegion();
            }
        }),
        reg_user(InstanceBackupsView.access$100().getString("word.reg_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudInstanceBackup)element).getRegUser();
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;
        private static SimpleDateFormat format;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }

        static {
            format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        }
    }
}

