/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudResourceManager;
import com.clustercontrol.cloud.presenter.Element;
import com.clustercontrol.cloud.presenter.HinemosService;
import com.clustercontrol.cloud.presenter.IFacilityRoot;
import com.clustercontrol.cloud.presenter.INode;
import com.clustercontrol.cloud.presenter.IScope;
import com.clustercontrol.cloud.presenter.Node;
import com.clustercontrol.cloud.presenter.RootScope;
import com.clustercontrol.cloud.presenter.Scope;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FacilityRoot
extends Element
implements IFacilityRoot {
    private HinemosService hinemosService;
    private RootScope rootScope;

    public FacilityRoot(HinemosService hinemosService) {
        this.hinemosService = hinemosService;
        try {
            FacilityTreeItem fti = new FacilityTree().getTreeItem();
            List<FacilityTreeItem> roots = this.collectTopScope(fti);
            for (FacilityTreeItem root : roots) {
                if (!"Cloud".equals(root.getData().getFacilityId())) continue;
                this.rootScope = new RootScope(this);
                this.rootScope.setName(root.getData().getFacilityName());
                this.rootScope.setFacilityId(root.getData().getFacilityId());
                this.rootScope.setScopeType(IScope.ScopeType.root);
                this.convertChildren(this.rootScope, root);
                break;
            }
        }
        catch (Exception e) {
            throw new CloudModelException("faild to get repositry tree.", e);
        }
    }

    @Override
    public void update() throws CloudModelException {
        try {
            List<FacilityTreeItem> roots = this.collectTopScope(new FacilityTree().getTreeItem());
            FacilityTreeItem cloudRoot = null;
            for (FacilityTreeItem root : roots) {
                if (!"Cloud".equals(root.getData().getFacilityId())) continue;
                cloudRoot = root;
                break;
            }
            if (cloudRoot != null) {
                if (this.rootScope == null) {
                    this.rootScope = new RootScope(this);
                    this.rootScope.setName(cloudRoot.getData().getFacilityName());
                    this.rootScope.setFacilityId(cloudRoot.getData().getFacilityId());
                    this.rootScope.setScopeType(IScope.ScopeType.root);
                    if (cloudRoot != null) {
                        this.convertChildren(this.rootScope, cloudRoot);
                    }
                    this.fireElementAdded(IFacilityRoot.p2.scopes, this.rootScope);
                } else {
                    this.recursiveUpdateScope(this.rootScope, cloudRoot);
                }
            } else if (this.rootScope != null) {
                RootScope oldScope = this.rootScope;
                this.rootScope = null;
                this.fireElementRemoved(IFacilityRoot.p2.scopes, oldScope);
            }
        }
        catch (CloudModelException e) {
            throw e;
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)"faild to get repositry tree.", (Throwable)e);
        }
        super.update();
    }

    private void recursiveUpdateScope(Scope parentScope, FacilityTreeItem facilityTreeItem) {
        parentScope.setName(facilityTreeItem.getData().getFacilityName());
        ArrayList treeItems = new ArrayList(facilityTreeItem.getChildren());
        ArrayList<Scope> scopes = new ArrayList<Scope>(Arrays.asList(parentScope.getScopes()));
        Iterator scopesIter = scopes.iterator();
        while (scopesIter.hasNext()) {
            Scope scope = (Scope)scopesIter.next();
            Iterator treeItemIter = treeItems.iterator();
            while (treeItemIter.hasNext()) {
                FacilityTreeItem treeItem = (FacilityTreeItem)treeItemIter.next();
                FacilityInfo fi = treeItem.getData();
                if (fi.getFacilityType() != 0 || !fi.getFacilityId().equals(scope.getFacilityId())) continue;
                this.recursiveUpdateScope(scope, treeItem);
                scopesIter.remove();
                treeItemIter.remove();
            }
        }
        for (Scope scope : scopes) {
            parentScope.removeChildScope(scope);
        }
        ArrayList<Node> nodes = new ArrayList<Node>(Arrays.asList(parentScope.getNodes()));
        Iterator nodesIter = nodes.iterator();
        while (nodesIter.hasNext()) {
            Node node = (Node)nodesIter.next();
            Iterator treeItemIter = treeItems.iterator();
            while (treeItemIter.hasNext()) {
                FacilityTreeItem treeItem = (FacilityTreeItem)treeItemIter.next();
                FacilityInfo fi = treeItem.getData();
                if (fi.getFacilityType() != 1 || !fi.getFacilityId().equals(node.getFacilityId())) continue;
                node.setName(fi.getFacilityName());
                nodesIter.remove();
                treeItemIter.remove();
            }
        }
        for (Node node : nodes) {
            parentScope.removeChildNode(node);
        }
        for (FacilityTreeItem treeItem : treeItems) {
            this.convertChild(parentScope, treeItem);
        }
    }

    public Scope[] getScopes() {
        if (this.rootScope != null) {
            return new Scope[]{this.rootScope};
        }
        return new Scope[0];
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.getHinemosService().getCloudResourceManager();
    }

    @Override
    public HinemosService getHinemosService() {
        return this.hinemosService;
    }

    private static Node convertNode(Scope parent, INode.NodeType nodeType, FacilityTreeItem fti) {
        Node node = new Node();
        node.setParent(parent);
        node.setName(fti.getData().getFacilityName());
        node.setFacilityId(fti.getData().getFacilityId());
        node.setNodeType(nodeType);
        return node;
    }

    private Scope convertScope(Scope parent, IScope.ScopeType type, FacilityTreeItem fti) {
        try {
            FacilityInfo fi = fti.getData();
            assert (fi.getFacilityType() == 0) : "unexpected";
            Scope scope = new Scope();
            scope.setParent(parent);
            scope.setName(fi.getFacilityName());
            scope.setFacilityId(fti.getData().getFacilityId());
            scope.setScopeType(type);
            return scope;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void convertChildren(Scope scope, FacilityTreeItem fti) {
        for (FacilityTreeItem child : fti.getChildren()) {
            this.convertChild(scope, child);
        }
    }

    private void convertChild(Scope parent, FacilityTreeItem child) {
        block0 : switch (child.getData().getFacilityType()) {
            case 0: {
                IScope.ScopeType nextType = null;
                block4 : switch (parent.getScopeType()) {
                    case root: {
                        if (!child.getData().getFacilityId().endsWith("_Scope")) break;
                        for (AccountResource ar : this.hinemosService.getCloudResourceManager().getAccountResourceManager().getAccountResources()) {
                            if (!child.getData().getFacilityId().equals(ar.getAccountResourceId() + "_Scope")) continue;
                            nextType = IScope.ScopeType.account_resource_scope;
                            break block4;
                        }
                        break;
                    }
                    case account_resource_scope: {
                        nextType = IScope.ScopeType.region;
                        break;
                    }
                    case region: {
                        nextType = IScope.ScopeType.zone;
                        break;
                    }
                }
                if (nextType == null) break;
                Scope childScope = this.convertScope(parent, nextType, child);
                parent.addChildScope(childScope);
                this.convertChildren(childScope, child);
                break;
            }
            case 1: {
                switch (parent.getScopeType()) {
                    case zone: {
                        parent.addChildNode(FacilityRoot.convertNode(parent, INode.NodeType.node, child));
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private static boolean isInternalScope(FacilityInfo facility) {
        return facility.getFacilityType() == 0 && ("REGISTERED".equals(facility.getFacilityId()) || "INTERNAL".equals(facility.getFacilityId()) || "UNREGISTERED".equals(facility.getFacilityId()));
    }

    private List<FacilityTreeItem> collectTopScope(FacilityTreeItem treeItem) {
        ArrayList<FacilityTreeItem> buf = new ArrayList<FacilityTreeItem>();
        return this.recursiveCollectTopScope(treeItem, buf);
    }

    private List<FacilityTreeItem> recursiveCollectTopScope(FacilityTreeItem treeItem, List<FacilityTreeItem> buf) {
        if (!this.isScope(treeItem.getData())) {
            for (FacilityTreeItem fti : treeItem.getChildren()) {
                this.recursiveCollectTopScope(fti, buf);
            }
        } else {
            buf.add(treeItem);
        }
        return buf;
    }

    private boolean isScope(FacilityInfo facility) {
        switch (facility.getFacilityType()) {
            case 0: {
                if (FacilityRoot.isInternalScope(facility)) break;
                return true;
            }
        }
        return false;
    }
}

