/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.Event;
import com.clustercontrol.cloud.presenter.EventListener;
import com.clustercontrol.cloud.presenter.EventNotifier2;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.PropChangedEventNotifier;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.presenter.PropertyObserver2;
import com.clustercontrol.cloud.presenter.Type;
import com.clustercontrol.cloud.presenter.ValueObserver2;
import java.lang.reflect.Field;

public abstract class Element
implements IElement {
    protected final PropChangedEventNotifier notifier3 = new PropChangedEventNotifier();
    protected final EventNotifier2 notifier2 = new EventNotifier2();

    @Override
    public void update() {
        this.fireEvent(new IElement.UpdateEvent(this));
    }

    @Override
    public <L extends EventListener> void addEventListener(Type<L> type, L listener) {
        this.notifier2.addEventListeners(type, listener);
    }

    @Override
    public <L extends EventListener> void removeEventListener(Type<L> type, L listener) {
        this.notifier2.removeEventListeners(type, listener);
    }

    protected <S, L extends EventListener> void fireEvent(Event<S, L> event) {
        this.notifier2.fireEvent(event);
    }

    @Override
    public <P, O extends PropertyObserver2<P>> void addPropertyObserver2(PropertyId2<O> pid, O observer) {
        this.notifier3.addPropertyObserver(pid, observer);
    }

    @Override
    public <P, O extends PropertyObserver2<P>> void removePropertyObserver2(PropertyId2<O> pid, O observer) {
        this.notifier3.removePropertyObserver(pid, observer);
    }

    protected <P> void firePropertyChanged2(Object source, PropertyId2<ValueObserver2<P>> pid, P newValue, P oldValue) {
        this.notifier3.fireValueChanged(this, pid, newValue, oldValue);
    }

    protected <P> void fireElementAdded(PropertyId2<CollectionObserver2<P>> pid, P addedValue) {
        this.notifier3.fireElementAdded(this, pid, addedValue);
    }

    public <P> void fireElementRemoved(PropertyId2<CollectionObserver2<P>> pid, P removedValue) {
        this.notifier3.fireElementRemoved(this, pid, removedValue);
    }

    protected <T> void internalSet(String propName, PropertyId2<ValueObserver2<T>> pid, T newValue) {
        Field f = null;
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                f = clazz.getDeclaredField(propName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        if (f == null) {
            throw new IllegalStateException("not foung field.field name is " + propName + ".");
        }
        boolean accessible = true;
        try {
            Object prop;
            accessible = f.isAccessible();
            if (!accessible) {
                f.setAccessible(true);
            }
            if ((prop = f.get(this)) == null ? newValue == null : prop.equals(newValue)) {
                return;
            }
            Object old = prop;
            f.set(this, newValue);
            this.firePropertyChanged2(this, pid, old, newValue);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        finally {
            if (!accessible) {
                f.setAccessible(false);
            }
        }
    }
}

