/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.presenter.CloudInstanceManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.cloud.presenter.RegistNodeRequest;
import com.clustercontrol.cloud.presenter.RunJobRequest;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InstanceStateChange;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.NodeDetail;
import com.clustercontrol.ws.cloud.StartInstanceRequest;
import com.clustercontrol.ws.cloud.StopInstanceRequest;
import java.util.ArrayList;
import java.util.List;

public class CloudInstance
extends InternalComponent<CloudInstanceManager, com.clustercontrol.ws.cloud.CloudInstance>
implements ICloudInstance {
    private String facilityId;
    private String facilityName;
    private String instanceId;
    private String instanceName;
    private String platform;
    private String cloudTypeId;
    private String region;
    private String zone;
    private String publicDnsName;
    private String state;
    private String registState;
    private String type;
    private String detail;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private String cloudUserId;
    private String flavor;
    private String imageId;
    private List<Tag> tags;
    private String templateId;

    public CloudInstance(CloudInstanceManager container) {
        super(container);
    }

    @Override
    @Export
    public String getFacilityId() {
        return this.facilityId;
    }

    @Import
    public void setFacilityId(String facilityId) {
        this.internalSet("facilityId", ICloudInstance.p2.facilityId, facilityId);
    }

    @Override
    @Export
    public String getFacilityName() {
        return this.facilityName;
    }

    @Import
    public void setFacilityName(String facilityName) {
        this.internalSet("facilityName", ICloudInstance.p2.facilityName, facilityName);
    }

    @Override
    @Export
    public String getInstanceId() {
        return this.instanceId;
    }

    @Import
    public void setInstanceId(String instanceId) {
        this.internalSet("instanceId", ICloudInstance.p2.instanceId, instanceId);
    }

    @Override
    @Export
    public String getInstanceName() {
        return this.instanceName;
    }

    @Import
    public void setInstanceName(String instanceName) {
        this.internalSet("instanceName", ICloudInstance.p2.instanceName, instanceName);
    }

    @Override
    @Export
    public String getPlatform() {
        return this.platform;
    }

    @Import
    public void setPlatform(String platform) {
        this.internalSet("platform", ICloudInstance.p2.platform, platform);
    }

    @Override
    @Export
    public String getCloudTypeId() {
        return this.cloudTypeId;
    }

    @Import
    public void setCloudTypeId(String cloudTypeId) {
        this.internalSet("cloudTypeId", ICloudInstance.p2.cloudTypeId, cloudTypeId);
    }

    @Override
    @Export
    public String getRegion() {
        return this.region;
    }

    @Import
    public void setRegion(String region) {
        this.internalSet("region", ICloudInstance.p2.region, region);
    }

    @Override
    @Export
    public String getZone() {
        return this.zone;
    }

    @Import
    public void setZone(String zone) {
        this.internalSet("zone", ICloudInstance.p2.zone, zone);
    }

    @Override
    @Export
    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    @Import
    public void setPublicDnsName(String publicDnsName) {
        this.internalSet("publicDnsName", ICloudInstance.p2.publicDnsName, publicDnsName);
    }

    @Override
    @Export
    public String getState() {
        return this.state;
    }

    @Import
    public void setState(String state) {
        this.internalSet("state", ICloudInstance.p2.state, state);
    }

    @Override
    @Export
    public String getRegistState() {
        return this.registState;
    }

    @Import
    public void setRegistState(String registState) {
        this.internalSet("registState", ICloudInstance.p2.registState, registState);
    }

    @Override
    @Export
    public String getType() {
        return this.type;
    }

    @Import
    public void setType(String type) {
        this.internalSet("type", ICloudInstance.p2.type, type);
    }

    @Override
    @Export
    public Long getRegDate() {
        return this.regDate;
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", ICloudInstance.p2.regDate, regDate);
    }

    @Override
    @Export
    public String getRegUser() {
        return this.regUser;
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", ICloudInstance.p2.regUser, regUser);
    }

    @Override
    @Export
    public Long getUpdateDate() {
        return this.updateDate;
    }

    @Import
    public void setUpdateDate(Long updateDate) {
        this.internalSet("updateDate", ICloudInstance.p2.updateDate, updateDate);
    }

    @Override
    @Export
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Import
    public void setUpdateUser(String updateUser) {
        this.internalSet("updateUser", ICloudInstance.p2.updateUser, updateUser);
    }

    @Override
    public CloudInstanceManager getCloudInstanceManager() {
        return (CloudInstanceManager)this.getContainer();
    }

    @Override
    public boolean equalValues(com.clustercontrol.ws.cloud.CloudInstance source) {
        return this.instanceId.equals(source.getInstanceId());
    }

    public static CloudInstance createCloudInstance(CloudInstanceManager cloudInstanceManager, com.clustercontrol.ws.cloud.CloudInstance source) {
        CloudInstance cloudInstance = new CloudInstance(cloudInstanceManager);
        cloudInstance.overwrite(source);
        return cloudInstance;
    }

    @Override
    public com.clustercontrol.ws.cloud.CloudInstance getSource() throws CloudModelException {
        try {
            return this.getEndpoint().getInstance(this.getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId(), this.region, this.instanceId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void overwrite(com.clustercontrol.ws.cloud.CloudInstance source) {
        ControlUtil.importObject(this, source);
        if (source.getBlockDeviceMappings() != null) {
            ArrayList<BlockDeviceMapping> list = new ArrayList<BlockDeviceMapping>();
            for (com.clustercontrol.ws.cloud.BlockDeviceMapping wsBlockDeviceMapping : source.getBlockDeviceMappings()) {
                list.add(new BlockDeviceMapping(wsBlockDeviceMapping.getStorageId(), wsBlockDeviceMapping.getDeviceName()));
            }
            this.setBlockDeviceMappings(list);
        }
        if (source.getTags() != null) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (com.clustercontrol.ws.cloud.Tag tag : source.getTags()) {
                tags.add(new Tag(tag.getKey(), tag.getValue()));
            }
            this.setTags(tags);
        }
        this.setCloudTypeId(source.getCloudTypeId());
        this.setType(source.getFlavor());
        if (source.getState() != null) {
            this.setState(ICloudInstance.StateType.valueOf(source.getState().value()).label());
        }
        this.setRegistState(source.getRegistState().value());
    }

    private CloudEndpoint getEndpoint() {
        return this.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String getRoleId() {
        return this.getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId();
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.internalSet("detail", ICloudInstance.p2.detail, detail);
    }

    @Override
    public void start() {
        StartInstanceRequest request = new StartInstanceRequest();
        request.setInstanceId(this.instanceId);
        try {
            InstanceStateChange change = this.getEndpoint().startInstance(this.getRoleId(), this.region, request);
            this.setState(ICloudInstance.StateType.valueOf(change.getCurrentState().value()).label());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void stop() {
        StopInstanceRequest request = new StopInstanceRequest();
        request.setInstanceId(this.instanceId);
        try {
            InstanceStateChange change = this.getEndpoint().stopInstance(this.getRoleId(), this.region, request);
            this.setState(ICloudInstance.StateType.valueOf(change.getCurrentState().value()).label());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void registNode(RegistNodeRequest registNodeRequest) {
        com.clustercontrol.ws.cloud.RegistNodeRequest wsRegistNodeRequest = new com.clustercontrol.ws.cloud.RegistNodeRequest();
        NodeDetail nodeDetail = new NodeDetail();
        wsRegistNodeRequest.setInstanceId(this.instanceId);
        RegistNodeRequest request = new RegistNodeRequest();
        ControlUtil.importObject(request, registNodeRequest);
        ControlUtil.exportObject(request, nodeDetail);
        wsRegistNodeRequest.setNodeDetail(nodeDetail);
        try {
            com.clustercontrol.ws.cloud.CloudInstance cloudInstance = this.getEndpoint().registNode(this.getRoleId(), this.region, wsRegistNodeRequest);
            this.overwrite(cloudInstance);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    @Export
    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    @Import
    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.internalSet("blockDeviceMappings", ICloudInstance.p2.blockDeviceMappings, blockDeviceMappings);
    }

    @Override
    @Export
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    @Import
    public void setCloudUserId(String cloudUserId) {
        this.internalSet("cloudUserId", ICloudInstance.p2.cloudUserId, cloudUserId);
    }

    @Override
    @Export
    public String getFlavor() {
        return this.flavor;
    }

    @Import
    public void setFlavor(String flavor) {
        this.internalSet("flavor", ICloudInstance.p2.flavor, flavor);
    }

    @Override
    @Export
    public String getImageId() {
        return this.imageId;
    }

    @Import
    public void setImageId(String imageId) {
        this.internalSet("imageId", ICloudInstance.p2.imageId, imageId);
    }

    @Override
    @Export
    public List<Tag> getTags() {
        return this.tags;
    }

    @Import
    public void setTags(List<Tag> tags) {
        this.internalSet("tags", ICloudInstance.p2.tags, tags);
    }

    @Override
    @Export
    public String getTemplateId() {
        return this.templateId;
    }

    @Import
    public void setTemplateId(String templateId) {
        this.internalSet("templateId", ICloudInstance.p2.templateId, templateId);
    }

    @Override
    public void attachStorage(String storageId, String device) {
        try {
            this.getEndpoint().attachStorage(this.getRoleId(), this.getRegion(), this.getInstanceId(), storageId, device);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void detachStorage(String storageId) {
        try {
            this.getEndpoint().detachStorage(this.getRoleId(), this.getRegion(), this.getInstanceId(), storageId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void start(RunJobRequest runJobRequest) {
        StartInstanceRequest request = new StartInstanceRequest();
        ControlUtil.exportObject(runJobRequest, request);
        this.convertArguments(request.getArguments(), runJobRequest.getArguments());
        request.setInstanceId(this.instanceId);
        try {
            InstanceStateChange change = this.getEndpoint().startInstance(this.getRoleId(), this.region, request);
            this.setState(ICloudInstance.StateType.valueOf(change.getCurrentState().value()).label());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void stop(RunJobRequest runJobRequest) {
        StopInstanceRequest request = new StopInstanceRequest();
        ControlUtil.exportObject(runJobRequest, request);
        this.convertArguments(request.getArguments(), runJobRequest.getArguments());
        request.setInstanceId(this.instanceId);
        try {
            InstanceStateChange change = this.getEndpoint().stopInstance(this.getRoleId(), this.region, request);
            this.setState(ICloudInstance.StateType.valueOf(change.getCurrentState().value()).label());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void establishAgentConnection() {
        try {
            this.getEndpoint().establishAgentConnection(this.getFacilityId());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    private void convertArguments(List<com.clustercontrol.ws.cloud.TemplateJobsArgument> wsArgs, List<TemplateJobsArgument> args) {
        if (args != null && args.size() > 0) {
            wsArgs.clear();
            for (TemplateJobsArgument arg : args) {
                com.clustercontrol.ws.cloud.TemplateJobsArgument wsArg = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
                ControlUtil.exportObject(arg, wsArg);
                wsArgs.add(wsArg);
            }
        }
    }
}

