/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class CloudOptinProxySelector extends ProxySelector {
	ProxySelector defaultSelector;
	
	public CloudOptinProxySelector(ProxySelector defaultSelector) {
		this.defaultSelector = defaultSelector;
	}

	// yahooかgoogleの場合だけプロキシを返すメソッド
	public List<Proxy> select(URI uri) {
		Proxy proxy = null;
		if (uri.getHost().endsWith("aws.amazon.com"))
//			proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("173.192.117.238", 8081));
			proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("qnap01", 3128));

		if (proxy == null)
			return defaultSelector.select(uri);
		else
			return Arrays.asList(proxy);
	}

	@Override
	public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
		ioe.printStackTrace();
	}
}