/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.fault.InvalidRole;

public class ModifiedEventNotifier<T> implements AutoCloseable {
	private String type;
	private Class<T> clazz;
	private T object;
	private boolean completed;
	
	public ModifiedEventNotifier(String type, Class<T> clazz, T object) throws CloudManagerFault, InvalidRole {
		this.type = type;
		this.clazz = clazz;
		this.object = object;
		try {
			ObjectRegistryService.registry().get(IObjectChangedService.class).firePreModifiedEvent(type, clazz, object);
		}
		catch (CloudManagerFault e) {
			if (e.getCause() instanceof InvalidRole) throw (InvalidRole)e.getCause();
			throw e;
		}
		catch (PluginFault e) {
			throw new CloudManagerFault(e);
		}
	}
	
	public void setCompleted() {
		completed = true;
	}

	@Override
	public void close() throws CloudManagerFault, InvalidRole {
		if (!completed) return;
		
		try {
			ObjectRegistryService.registry().get(IObjectChangedService.class).firePostModifiedEvent(type, clazz, object);
		}
		catch (CloudManagerFault e) {
			if (e.getCause() instanceof InvalidRole) throw (InvalidRole)e.getCause();
			throw e;
		}
		catch (PluginFault e) {
			throw new CloudManagerFault(e);
		}
	}
}