/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.clustercontrol.cloud.InternalManagerError;

public class FunctionTable {
	private static Map<String, Set<String>> table = new HashMap<String, Set<String>>();
	
	public synchronized static void registerFunction(String functionId) {
		Set<String> set = table.get(functionId);
		if (set == null) {
			set = new HashSet<>();
			table.put(functionId, set);
		}
	}
	public synchronized static void enable(String functionId, String serviceId) {
		Set<String> set = table.get(functionId);
		if (set == null) {
			throw new InternalManagerError();
		}
		set.add(serviceId);
	}
	public synchronized static boolean isEnabled(String functionId, String serviceId) {
		Set<String> set = table.get(functionId);
		if (set == null) {
			throw new InternalManagerError();
		}
		return set.contains(serviceId);
	}
}
