/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.aws.util.AWSConstants;
import com.clustercontrol.cloud.aws.util.AWSUtil;
import com.clustercontrol.cloud.aws.util.SecurityGroupUtil;
import com.clustercontrol.cloud.factory.CloudRoleConstants;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role_region;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.ws.aws.AWSOptionEndpoint;
import com.clustercontrol.ws.aws.KeyPair;
import com.clustercontrol.ws.aws.SecurityGroup;
import com.clustercontrol.ws.aws.Subnet;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloud.security.HinemosAccessRight;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;

@WebService(serviceName="AWSOptionEndpointService", portName="AWSOptionEndpointPort", targetNamespace="http://aws.ws.clustercontrol.com", endpointInterface="com.clustercontrol.ws.aws.AWSOptionEndpoint")
public class AWSOptionEndpointImpl
implements AWSOptionEndpoint,
IWebServiceBase,
AWSConstants,
CloudRoleConstants {
    @Resource
    private WebServiceContext wsctx;

    private static AmazonEC2 getAmazonEC2() throws CloudManagerFault {
        final ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
        return AWSUtil.createAmazonEC2(new IResourceManagement.ICredential(){

            public String getSecretKey() throws CloudManagerFault {
                return context.getAccessDestionation().getCloudUser().getSecretKey();
            }

            public String getAccessKey() throws CloudManagerFault {
                return context.getAccessDestionation().getCloudUser().getAccessKey();
            }
        }, context.getCurrentRegion().getEndpoint("ec2").getLocation());
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<KeyPair> getKeyNames(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            DescribeKeyPairsResult awsResult = AWSOptionEndpointImpl.getAmazonEC2().describeKeyPairs();
            ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>();
            for (KeyPairInfo awsKeyPair : awsResult.getKeyPairs()) {
                KeyPair kp = new KeyPair();
                kp.setKeyName(awsKeyPair.getKeyName());
                keyPairs.add(kp);
            }
            return keyPairs;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<Subnet> getSubnets(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            DescribeSubnetsResult awsResult = AWSOptionEndpointImpl.getAmazonEC2().describeSubnets();
            for (com.amazonaws.services.ec2.model.Subnet awsSubnet : awsResult.getSubnets()) {
                Subnet subnet = new Subnet();
                subnet.setSubnetId(awsSubnet.getSubnetId());
                subnet.setVpcId(awsSubnet.getVpcId());
                subnet.setAvailabilityZone(awsSubnet.getAvailabilityZone());
                subnet.setCidrBlock(awsSubnet.getCidrBlock());
                subnets.add(subnet);
            }
            return subnets;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public String getWindowsPassword(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull @Size(max=64) String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            return AWSOptionEndpointImpl.getAmazonEC2().getPasswordData(new GetPasswordDataRequest().withInstanceId(instanceId)).getPasswordData();
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<SecurityGroup> getSecurityGroups(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            DescribeSecurityGroupsResult dsgResult = AWSOptionEndpointImpl.getAmazonEC2().describeSecurityGroups();
            ArrayList<SecurityGroup> groups = new ArrayList<SecurityGroup>();
            for (com.amazonaws.services.ec2.model.SecurityGroup awsSg : dsgResult.getSecurityGroups()) {
                SecurityGroup sg = SecurityGroupUtil.convertToSecrurityGroup(awsSg);
                groups.add(sg);
            }
            return groups;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault((Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<SecurityGroup> getSecurityGroupsWithFilters(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="filters") @NotNull @NotNullContainer @Into List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        try {
            DescribeSecurityGroupsRequest awsRequest = new DescribeSecurityGroupsRequest();
            for (Filter f : filters) {
                com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter(f.getName(), f.getValues());
                awsRequest.getFilters().add(awsFilter);
            }
            DescribeSecurityGroupsResult result = AWSOptionEndpointImpl.getAmazonEC2().describeSecurityGroups(awsRequest);
            ArrayList<SecurityGroup> groups = new ArrayList<SecurityGroup>();
            for (com.amazonaws.services.ec2.model.SecurityGroup awsSg : result.getSecurityGroups()) {
                SecurityGroup sg = SecurityGroupUtil.convertToSecrurityGroup(awsSg);
                groups.add(sg);
            }
            return groups;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

