/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.dao;

import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.dao.HinemosObjectDao;
import com.clustercontrol.cloud.persistence.BooleanTFConverter;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="cc_cloud_account_resource")
public class CloudAccountResourceDao
extends HinemosObjectDao
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private String accountResourceId;
    private String accountResourceName;
    private String cloudServiceId;
    private CloudUserDao account;
    private boolean billingDetailCollectorFlg;
    private int retentionPeriod;
    private String description;
    private Timestamp billingLastDate;
    static final long serialVersionUID = 8727785085939045044L;

    public CloudAccountResourceDao() {
    }

    public CloudAccountResourceDao(String accountResourceId, String accountResourceName, String cloudServiceId, CloudUserDao adminUser, String description, Timestamp billingLastDate, Timestamp regDate, Timestamp updateDate, String regUser, String updateUser) {
        super(regDate, updateDate, regUser, updateUser);
        this.setAccountResourceId(accountResourceId);
        this.setAccountResourceName(accountResourceName);
        this.setCloudServiceId(cloudServiceId);
        this.setAccount(adminUser);
        this.setDescription(description);
        this.setBillingLastDate(billingLastDate);
    }

    public CloudAccountResourceDao(CloudAccountResourceDao otherData) {
        super(otherData);
        this.setAccountResourceId(otherData.getAccountResourceId());
        this.setAccountResourceName(otherData.getAccountResourceName());
        this.setCloudServiceId(otherData.getCloudServiceId());
        this.setAccount(otherData.getAccount());
        this.setDescription(otherData.getDescription());
        this.setBillingLastDate(otherData.getBillingLastDate());
    }

    @Id
    @Column(name="account_resource_id")
    public String getAccountResourceId() {
        return this._persistence_get_accountResourceId();
    }

    public void setAccountResourceId(String accountResourceId) {
        this._persistence_set_accountResourceId(accountResourceId);
    }

    @Column(name="account_resource_name")
    public String getAccountResourceName() {
        return this._persistence_get_accountResourceName();
    }

    public void setAccountResourceName(String accountResourceName) {
        this._persistence_set_accountResourceName(accountResourceName);
    }

    @Column(name="cloud_service_id")
    public String getCloudServiceId() {
        return this._persistence_get_cloudServiceId();
    }

    public void setCloudServiceId(String cloudServiceId) {
        this._persistence_set_cloudServiceId(cloudServiceId);
    }

    @JoinColumn(name="account_id")
    public CloudUserDao getAccount() {
        return this._persistence_get_account();
    }

    public void setAccount(CloudUserDao account) {
        this._persistence_set_account(account);
    }

    @Convert(converter=BooleanTFConverter.class)
    @Column(name="billing_detail_collector_flg")
    public boolean getBillingDetailCollectorFlg() {
        return this._persistence_get_billingDetailCollectorFlg();
    }

    public void setBillingDetailCollectorFlg(boolean billingDetailCollectorFlg) {
        this._persistence_set_billingDetailCollectorFlg(billingDetailCollectorFlg);
    }

    @Column(name="retention_period")
    public int getRetentionPeriod() {
        return this._persistence_get_retentionPeriod();
    }

    public void setRetentionPeriod(int retentionPeriod) {
        this._persistence_set_retentionPeriod(retentionPeriod);
    }

    @Column(name="description")
    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    @Column(name="billing_last_date")
    public Timestamp getBillingLastDate() {
        return this._persistence_get_billingLastDate();
    }

    public void setBillingLastDate(Timestamp billingLastDate) {
        this._persistence_set_billingLastDate(billingLastDate);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._persistence_get_accountResourceId() == null ? 0 : this._persistence_get_accountResourceId().hashCode());
        result = 31 * result + (this._persistence_get_accountResourceName() == null ? 0 : this._persistence_get_accountResourceName().hashCode());
        result = 31 * result + (this._persistence_get_billingDetailCollectorFlg() ? 1231 : 1237);
        result = 31 * result + (this._persistence_get_billingLastDate() == null ? 0 : this._persistence_get_billingLastDate().hashCode());
        result = 31 * result + (this._persistence_get_cloudServiceId() == null ? 0 : this._persistence_get_cloudServiceId().hashCode());
        result = 31 * result + (this._persistence_get_description() == null ? 0 : this._persistence_get_description().hashCode());
        result = 31 * result + this._persistence_get_retentionPeriod();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloudAccountResourceDao other = (CloudAccountResourceDao)obj;
        if (this._persistence_get_accountResourceId() == null ? other._persistence_get_accountResourceId() != null : !this._persistence_get_accountResourceId().equals(other._persistence_get_accountResourceId())) {
            return false;
        }
        if (this._persistence_get_accountResourceName() == null ? other._persistence_get_accountResourceName() != null : !this._persistence_get_accountResourceName().equals(other._persistence_get_accountResourceName())) {
            return false;
        }
        if (this._persistence_get_billingDetailCollectorFlg() != other._persistence_get_billingDetailCollectorFlg()) {
            return false;
        }
        if (this._persistence_get_billingLastDate() == null ? other._persistence_get_billingLastDate() != null : !this._persistence_get_billingLastDate().equals(other._persistence_get_billingLastDate())) {
            return false;
        }
        if (this._persistence_get_cloudServiceId() == null ? other._persistence_get_cloudServiceId() != null : !this._persistence_get_cloudServiceId().equals(other._persistence_get_cloudServiceId())) {
            return false;
        }
        if (this._persistence_get_description() == null ? other._persistence_get_description() != null : !this._persistence_get_description().equals(other._persistence_get_description())) {
            return false;
        }
        return this._persistence_get_retentionPeriod() == other._persistence_get_retentionPeriod();
    }

    @Override
    public String toString() {
        return "CloudAccountResourceDao [accountResourceId=" + this._persistence_get_accountResourceId() + ", accountResourceName=" + this._persistence_get_accountResourceName() + ", cloudServiceId=" + this._persistence_get_cloudServiceId() + ", billingDetailCollectorFlg=" + this._persistence_get_billingDetailCollectorFlg() + ", retentionPeriod=" + this._persistence_get_retentionPeriod() + ", description=" + this._persistence_get_description() + ", billingLastDate=" + this._persistence_get_billingLastDate() + "]";
    }

    public String getId() {
        return this.getAccountResourceId();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CloudAccountResourceDao(persistenceObject);
    }

    public CloudAccountResourceDao(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "cloudServiceId") {
            return this.cloudServiceId;
        }
        if (string == "billingLastDate") {
            return this.billingLastDate;
        }
        if (string == "billingDetailCollectorFlg") {
            return this.billingDetailCollectorFlg;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "accountResourceId") {
            return this.accountResourceId;
        }
        if (string == "retentionPeriod") {
            return this.retentionPeriod;
        }
        if (string == "account") {
            return this.account;
        }
        if (string == "accountResourceName") {
            return this.accountResourceName;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "cloudServiceId") {
            this.cloudServiceId = (String)object;
            return;
        }
        if (string == "billingLastDate") {
            this.billingLastDate = (Timestamp)object;
            return;
        }
        if (string == "billingDetailCollectorFlg") {
            this.billingDetailCollectorFlg = (Boolean)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "accountResourceId") {
            this.accountResourceId = (String)object;
            return;
        }
        if (string == "retentionPeriod") {
            this.retentionPeriod = (Integer)object;
            return;
        }
        if (string == "account") {
            this.account = (CloudUserDao)object;
            return;
        }
        if (string == "accountResourceName") {
            this.accountResourceName = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_cloudServiceId() {
        this._persistence_checkFetched("cloudServiceId");
        return this.cloudServiceId;
    }

    public void _persistence_set_cloudServiceId(String string) {
        this._persistence_checkFetchedForSet("cloudServiceId");
        this._persistence_propertyChange("cloudServiceId", this.cloudServiceId, string);
        this.cloudServiceId = string;
    }

    public Timestamp _persistence_get_billingLastDate() {
        this._persistence_checkFetched("billingLastDate");
        return this.billingLastDate;
    }

    public void _persistence_set_billingLastDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("billingLastDate");
        this._persistence_propertyChange("billingLastDate", this.billingLastDate, timestamp);
        this.billingLastDate = timestamp;
    }

    public boolean _persistence_get_billingDetailCollectorFlg() {
        this._persistence_checkFetched("billingDetailCollectorFlg");
        return this.billingDetailCollectorFlg;
    }

    public void _persistence_set_billingDetailCollectorFlg(boolean bl) {
        this._persistence_checkFetchedForSet("billingDetailCollectorFlg");
        this._persistence_propertyChange("billingDetailCollectorFlg", new Boolean(this.billingDetailCollectorFlg), new Boolean(bl));
        this.billingDetailCollectorFlg = bl;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public String _persistence_get_accountResourceId() {
        this._persistence_checkFetched("accountResourceId");
        return this.accountResourceId;
    }

    public void _persistence_set_accountResourceId(String string) {
        this._persistence_checkFetchedForSet("accountResourceId");
        this._persistence_propertyChange("accountResourceId", this.accountResourceId, string);
        this.accountResourceId = string;
    }

    public int _persistence_get_retentionPeriod() {
        this._persistence_checkFetched("retentionPeriod");
        return this.retentionPeriod;
    }

    public void _persistence_set_retentionPeriod(int n) {
        this._persistence_checkFetchedForSet("retentionPeriod");
        this._persistence_propertyChange("retentionPeriod", new Integer(this.retentionPeriod), new Integer(n));
        this.retentionPeriod = n;
    }

    public CloudUserDao _persistence_get_account() {
        this._persistence_checkFetched("account");
        return this.account;
    }

    public void _persistence_set_account(CloudUserDao cloudUserDao) {
        this._persistence_checkFetchedForSet("account");
        this._persistence_propertyChange("account", this.account, cloudUserDao);
        this.account = cloudUserDao;
    }

    public String _persistence_get_accountResourceName() {
        this._persistence_checkFetched("accountResourceName");
        return this.accountResourceName;
    }

    public void _persistence_set_accountResourceName(String string) {
        this._persistence_checkFetchedForSet("accountResourceName");
        this._persistence_propertyChange("accountResourceName", this.accountResourceName, string);
        this.accountResourceName = string;
    }
}

