/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.TemplateJobsArgument;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.util.JobControllerBeanWrapper;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidObjectPrivilege;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.JobInfoNotFound;
import com.clustercontrol.fault.JobInvalid;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.JobSessionDuplicate;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.fault.UserNotFound;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.notify.factory.NotifyEventTaskFactory;
import com.clustercontrol.plugin.impl.AsyncWorkerPlugin;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class TemplateJobUtil
implements CloudConstants {
    public static void asyncExecute(String facilityId, String jobunitId, String jobId, List<TemplateJobsArgument> arguments, JobEventListener beforeExecute, JobEventListener afterExecute) {
        JobExecutor jobExecutor = new JobExecutor(facilityId, jobunitId, jobId, arguments, beforeExecute, afterExecute);
        jobExecutor.asyncExecute();
    }

    public static void syncExecute(String facilityId, String jobunitId, String jobId, List<TemplateJobsArgument> arguments, JobEventListener beforeExecute, JobEventListener afterExecute) throws Exception {
        JobExecutor jobExecutor = new JobExecutor(facilityId, jobunitId, jobId, arguments, beforeExecute, afterExecute);
        jobExecutor.syncExecute();
    }

    public static class InternalEventNotifier
    implements Callable<Boolean> {
        private static final String MONITOR_ID = "SYS";
        private static final String APPLICATION = Messages.messages().getString("cloud.template.message.notify.application");
        private static final String MESSAGE_ID = "001";
        private static final int PRIORITY = 2;
        private String pluginId;
        private String facilityId;
        private String message;

        public InternalEventNotifier(String pluginId, String facilityId, String message) {
            this.pluginId = pluginId;
            this.facilityId = facilityId;
            this.message = message;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                OutputBasicInfo output = new OutputBasicInfo();
                output.setPluginId(this.pluginId);
                output.setMonitorId(MONITOR_ID);
                output.setFacilityId(this.facilityId);
                RepositoryControllerBean repositoryLocal = new RepositoryControllerBean();
                NodeInfo nodeInfo = repositoryLocal.getNode(this.facilityId);
                output.setScopeText(nodeInfo.getFacilityName());
                output.setApplication(APPLICATION);
                output.setMessageId(MESSAGE_ID);
                output.setMessage(this.message);
                output.setPriority(2);
                output.setGenerationDate(Long.valueOf(new Date().getTime()));
                AsyncWorkerPlugin.addTask((String)NotifyEventTaskFactory.class.getSimpleName(), (Serializable)output, (boolean)false);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(TemplateJobUtil.class);
                logger.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
    }

    private static class JobExecutor {
        private String facilityId;
        private String jobunitId;
        private String jobId;
        private List<TemplateJobsArgument> arguments;
        private JobEventListener beforeExecute;
        private JobEventListener afterExecute;

        public JobExecutor(String facilityId, String jobunitId, String jobId, List<TemplateJobsArgument> arguments, JobEventListener beforeExecute, JobEventListener afterExecute) {
            this.jobunitId = jobunitId;
            this.jobId = jobId;
            this.facilityId = facilityId;
            this.arguments = arguments;
            this.beforeExecute = beforeExecute;
            this.afterExecute = afterExecute;
        }

        public void asyncExecute() {
            SessionService.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        JobExecutor.this.syncExecute();
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }

        public void syncExecute() throws Exception {
            Logger logger = Logger.getLogger(this.getClass());
            if (this.beforeExecute != null) {
                this.beforeExecute.jobEventOccurerd(this.facilityId, this.jobunitId, this.jobId);
            }
            String sessionId = this.executeJob();
            if (this.afterExecute != null) {
                int maxCount = Integer.parseInt(CloudPropertyConstants.templatejob_endcheck_count.value());
                long interval = Long.parseLong(CloudPropertyConstants.templatejob_endcheck_interval.value());
                int counter = 0;
                while (counter < maxCount) {
                    logger.debug((Object)("try to check end of job. facilityId:" + this.facilityId + ",jobId:" + this.jobId + ",sessionId:" + sessionId + " " + ++counter + "/" + maxCount + " time."));
                    if (!JobUtil.isRunJob((String)sessionId, (String)this.jobunitId, (String)this.jobId)) {
                        this.afterExecute.jobEventOccurerd(this.facilityId, this.jobunitId, this.jobId);
                        break;
                    }
                    if (counter >= maxCount) {
                        throw new CloudManagerFault("timed out waiting for end of job.");
                    }
                    Thread.sleep(interval);
                }
            }
        }

        private String executeJob() throws CloudManagerFault, NotifyNotFound, HinemosUnknown, JobMasterNotFound, UserNotFound, InvalidRole, JobInvalid, InvalidObjectPrivilege, FacilityNotFound, JobInfoNotFound, JobSessionDuplicate {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("runJob : jobunitId=" + this.jobunitId + ", jobId=" + this.jobId + ", facilityId=" + this.facilityId));
            JobControllerBeanWrapper bean = JobControllerBeanWrapper.bean();
            JobTreeItem root = bean.getJobTree(null, true, Locale.getDefault());
            JobTreeItem awsRoot = null;
            for (JobTreeItem item : ((JobTreeItem)root.getChildren().get(0)).getChildren()) {
                if (!item.getData().getId().equals(this.jobunitId)) continue;
                awsRoot = item;
                break;
            }
            if (awsRoot != null) {
                JobInfo jobInfo = bean.getJobFull(awsRoot.getData());
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(jobInfo);
                    oos.flush();
                    oos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    jobInfo = (JobInfo)ois.readObject();
                    ois.close();
                }
                catch (Exception e) {
                    throw new InternalManagerError((Throwable)e);
                }
                awsRoot.setData(jobInfo);
                ArrayList paramList = jobInfo.getParam();
                if (paramList != null && this.arguments != null && this.arguments.size() > 0) {
                    for (JobParameterInfo param : paramList) {
                        for (TemplateJobsArgument arg : this.arguments) {
                            if (!param.getParamId().equals(this.jobunitId + "_" + arg.getJobId())) continue;
                            param.setValue(arg.getArg());
                        }
                    }
                    awsRoot.setData(jobInfo);
                    bean.registerJobunit(awsRoot);
                }
            } else {
                throw new CloudManagerFault("Jobunit AWS not found.");
            }
            JobTriggerInfo triggerInfo = new JobTriggerInfo();
            triggerInfo.setTrigger_info(JobTriggerTypeConstant.STRING_MANUAL);
            triggerInfo.setTrigger_type(Integer.valueOf(2));
            OutputBasicInfo info = new OutputBasicInfo();
            info.setFacilityId(this.facilityId);
            return bean.runJob(this.jobunitId, this.jobId, info, triggerInfo);
        }
    }

    public static interface JobEventListener {
        public void jobEventOccurerd(String var1, String var2, String var3) throws Exception;
    }
}

