/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.util.Tuple;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CriticalPoint {
    private static Map<Tuple, CriticalPoint> criticalPointMap = new HashMap<Tuple, CriticalPoint>();
    private AtomicInteger syncCount = new AtomicInteger();

    public void enter() {
        this.syncCount.incrementAndGet();
    }

    public void leave() {
        this.syncCount.decrementAndGet();
    }

    public boolean isEntering() {
        return this.syncCount.get() > 0;
    }

    public static synchronized CriticalPoint getCriticalPoint(String accountResourceId, String region) {
        CriticalPoint cp = criticalPointMap.get(Tuple.build((Object[])new Object[]{accountResourceId, region}));
        if (cp == null) {
            cp = new CriticalPoint();
            criticalPointMap.put(Tuple.build((Object[])new Object[]{accountResourceId, region}), cp);
        }
        return cp;
    }

    public static synchronized void removeCriticalPoint(String accountResourceId) {
        Iterator<Map.Entry<Tuple, CriticalPoint>> iter = criticalPointMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Tuple, CriticalPoint> entry = iter.next();
            if (!entry.getKey().get(0).equals(accountResourceId)) continue;
            iter.remove();
        }
    }
}

