/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.persistence;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.Transactional;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PersistenceUtil {
    public static <T> T decorateTransactional(Class<T> interfaceClass, T implementer) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new TransactionalInvoker2(implementer)));
    }

    private static class TransactionalInvoker2
    implements InvocationHandler {
        private Object implementor;

        public TransactionalInvoker2(Object implementor) {
            this.implementor = implementor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean requiredNew = false;
            try {
                Method m;
                Transactional mt;
                SessionService.ISession session = SessionService.current();
                boolean transactional = false;
                Transactional ct = this.implementor.getClass().getAnnotation(Transactional.class);
                if (ct != null) {
                    switch (ct.value()) {
                        case Required: {
                            transactional = !session.isTransaction();
                            break;
                        }
                        case RequiredNew: {
                            transactional = true;
                            requiredNew = true;
                            break;
                        }
                    }
                }
                if ((mt = (m = this.implementor.getClass().getMethod(method.getName(), method.getParameterTypes())).getAnnotation(Transactional.class)) != null) {
                    transactional = mt.value() == Transactional.TransactionType.Required;
                    switch (mt.value()) {
                        case Required: {
                            transactional = !session.isTransaction();
                            requiredNew = false;
                            break;
                        }
                        case RequiredNew: {
                            transactional = true;
                            requiredNew = true;
                            break;
                        }
                    }
                }
                if (requiredNew) {
                    SessionService.offer();
                    session = SessionService.current();
                }
                if (transactional) {
                    session.beginTransaction();
                    Object result = null;
                    try {
                        result = method.invoke(this.implementor, args);
                    }
                    catch (Exception e) {
                        session.rollbackTransaction();
                        throw e;
                    }
                    session.commitTransaction();
                    Object object = result;
                    return object;
                }
                Object object = method.invoke(this.implementor, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalManagerError((Throwable)e);
            }
            finally {
                if (requiredNew) {
                    SessionService.poll();
                }
            }
        }
    }

    public static class TransactionScope
    implements AutoCloseable {
        private boolean completed = false;
        private boolean transactional = false;
        private boolean requiredNew = false;

        public TransactionScope() {
            this(Transactional.TransactionType.Required);
        }

        public TransactionScope(Transactional.TransactionType transactionType) {
            SessionService.ISession session = SessionService.current();
            switch (transactionType) {
                case Required: {
                    this.transactional = !session.isTransaction();
                    break;
                }
                case RequiredNew: {
                    this.transactional = true;
                    this.requiredNew = true;
                    break;
                }
            }
            if (this.requiredNew) {
                SessionService.offer();
                session = SessionService.current();
            }
            if (this.transactional) {
                session.beginTransaction();
            }
        }

        public void complete() {
            this.completed = true;
        }

        @Override
        public void close() {
            if (!this.completed) {
                SessionService.current().rollbackTransaction();
            } else if (this.transactional) {
                SessionService.current().commitTransaction();
            }
            if (this.requiredNew) {
                SessionService.poll();
            }
        }
    }
}

