/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.clustercontrol.cloud.persistence.IDHolder;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_type_mst")
public class CloudTypeDao implements IDHolder {
	private java.lang.String id;
	private java.lang.String name;
	private java.lang.String description;

	public CloudTypeDao()
	{
	}

	public CloudTypeDao( java.lang.String id,java.lang.String name,java.lang.String description )
	{
		setCloudId(id);
		setName(name);
		setDescription(description);
	}

	public CloudTypeDao( CloudTypeDao otherData )
	{
		setCloudId(otherData.getCloudId());
		setName(otherData.getName());
		setDescription(otherData.getDescription());

	}

	@Column(name="cloud_id")
	@Id
	public java.lang.String getCloudId()
	{
		return this.id;
	}
	public void setCloudId( java.lang.String id )
	{
		this.id = id;
	}

	@Column(name="cloud_name")
	public java.lang.String getName()
	{
		return this.name;
	}
	public void setName( java.lang.String name )
	{
		this.name = name;
	}

	@Column(name="description")
	public java.lang.String getDescription()
	{
		return this.description;
	}
	public void setDescription( java.lang.String description )
	{
		this.description = description;
	}

	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("id=" + getId() + " " + "name=" + getName() + " " + "description=" + getDescription());
		str.append('}');

		return(str.toString());
	}

	public boolean equals( Object pOther )
	{
		if( pOther instanceof CloudTypeDao )
		{
			CloudTypeDao lTest = (CloudTypeDao) pOther;
			boolean lEquals = true;

			if( this.id == null )
			{
				lEquals = lEquals && ( lTest.id == null );
			}
			else
			{
				lEquals = lEquals && this.id.equals( lTest.id );
			}
			if( this.name == null )
			{
				lEquals = lEquals && ( lTest.name == null );
			}
			else
			{
				lEquals = lEquals && this.name.equals( lTest.name );
			}
			if( this.description == null )
			{
				lEquals = lEquals && ( lTest.description == null );
			}
			else
			{
				lEquals = lEquals && this.description.equals( lTest.description );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.id != null) ? this.id.hashCode() : 0);

		result = 37*result + ((this.name != null) ? this.name.hashCode() : 0);

		result = 37*result + ((this.description != null) ? this.description.hashCode() : 0);

		return result;
	}
	
	@Override
	public String getId() {
		return getCloudId();
	}
}
