/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

public enum InstanceRegistStateType {
	registered((short)0),
	unregistered((short)1),
	deleted((short)2);

	private short num;
	
	private InstanceRegistStateType(short num) {
		this.num = num;
	}
	
	public short number() {
		return num;
	}
	
	public static InstanceRegistStateType byNumber(short num) {
		for (InstanceRegistStateType type: InstanceRegistStateType.values()) {
			if (type.number() == num) {
				return type;
			}
		}
		return null;
	}
}
