/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud;



public class CloudManagerFault extends PluginFault {
	/**
	 * 
	 */
	private static final long serialVersionUID = -3153406804815913446L;
	
	public CloudManagerFault() {
		super();
	}

	public CloudManagerFault(String message, String errorCode, Throwable cause) {
		super(message, errorCode, cause);
	}

	public CloudManagerFault(String message, String errorCode) {
		super(message, errorCode);
	}

	public CloudManagerFault(String message, Throwable cause) {
		super(message, cause);
	}

	public CloudManagerFault(String message) {
		super(message);
	}

	public CloudManagerFault(Throwable cause) {
		this(getMessage(cause), getCode(cause), cause);
	}

	public static String getMessage(Throwable cause) {
		return cause instanceof PluginFault ? ((PluginFault)cause).getUndecoratedMessage():(cause.getMessage() == null ? cause.toString(): cause.getMessage());
	}

	public static String getCode(Throwable cause) {
		return cause instanceof PluginFault ? ((PluginFault)cause).getErrorCode():"UNEXPECTED";
	}
}