/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.jdt.annotation.Nullable;

import com.clustercontrol.cloud.util.Tuple;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;

public class ParamAnnotations {
	private ParamAnnotations() {
	}
	
	private static ParamHolder.Param createParam(DirectParam dp, Object v) {
		return ParamHolder.Param.build(dp.name(), v.toString());
	}
	
	private static Collection<ParamHolder.Param> createParam(MarshalParam mp, Object c) {
		MarshalParam.marshaller m;
		try {
			m = mp.value().newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			throw CloudnRestfulApplicationError.Params_NotInitialiseMarshaller.exception(e);
		}
		return m.marshal(c);
	}
	
	public static Collection<ParamHolder.Param> makeRestParams(Method method, @Nullable Object[] args) {
		Preconditions.checkNotNull(method);
		
		// 引数無しなので終了。
		if (args == null || args.length == 0) return Collections.emptyList();
		
		Invokable<?, Object> invokable = Invokable.from(method);
		
		ImmutableList<Parameter> metodParams = invokable.getParameters();
		List<Tuple> tuples = new ArrayList<>();
		for (int i = 0; i < metodParams.size(); ++i) {
			tuples.add(Tuple.build(metodParams.get(i), args[i]));
		}
		
		List<ParamHolder.Param> restParams = new ArrayList<>();
		for (int i = 0; i < tuples.size(); ++i) {
			try {
				restParams.addAll(ParamAnnotations.makeRestParamsFromMethodParam(tuples.get(i).get(0, Parameter.class), tuples.get(i).get(1)));
			}
			catch (RestfulApplicationException e) {
				if (CloudnRestfulApplicationError.Params_NeedParamAnotation.match(e)) {
					throw CloudnRestfulApplicationError.Params_NeedParamAnotation.exception(method.getName(), i);
				}
			}
		}
		return restParams;
	}
	
	public static Collection<ParamHolder.Param> makeRestParamsFromMethodParam(Parameter p, @Nullable Object v) {
		if (v == null) return Collections.emptyList();

		DirectParam dp = p.getAnnotation(DirectParam.class);
		if (dp != null) {
			return Arrays.asList(createParam(dp, v));
		}
		MarshalParam mp = p.getAnnotation(MarshalParam.class);
		if (mp != null) {
			return createParam(mp, v);
		}
		mp = v.getClass().getAnnotation(MarshalParam.class);
		if (mp != null) {
			return createParam(mp, v);
		}
		throw CloudnRestfulApplicationError.Params_NeedParamAnotation.exception();
	}
	
	public static Collection<ParamHolder.Param> makeRestParamsFromField(Field f, @Nullable Object c) {
		if (c == null) return Collections.emptyList();

		@Nullable Object v;
		try {
			v = f.get(c);
		} catch (IllegalArgumentException | IllegalAccessException e) {
			throw CloudnRestfulApplicationError.Params_FailToMakeParamString.exception(e);
		}

		if (v == null) return Collections.emptyList();

		DirectParam dp = f.getAnnotation(DirectParam.class);
		if (dp != null) {
			return Arrays.asList(createParam(dp, v));
		}
		MarshalParam mp = f.getAnnotation(MarshalParam.class);
		if (mp != null) {
			return createParam(mp, v);
		}
		
		return Arrays.asList(ParamHolder.Param.build(f.getName(), v.toString()));
	}
}