/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class ListVolumesRequest extends RestApplicationRequest {
	// 指定したアカウントに属する情報に絞り込む。domainidと同時に利用する 
	public String account;
	
	// 取得する情報にフィルターを設定する。指定出来るあたいは、 all, vm, account, storage_type, 	disk_offering及びmin。
	// 複数指定する場合は、カンマ（,）区切りで指定する。 
	public String details;
	
	// ドメインIDを指定する。指定することにより、指定したドメイン以下の情報に絞り込む
	public String domainid;
	
	// テンプレートのIDを指定
	public String id;
	
	// サブドメインが保有するDisk Voluneも検索対象とする
	public Boolean isrecursive;

	// キーワードによる検索を実施する
	public String keyword;

	// true/ falseで指定する(default false). zoneidとisrecursive=trueと設定した場合に等しい
	public Boolean listall;

	// Volume名を指定して、検索を実施する
	public String name;

	// pagesizeと同時に指定して、ページ番号を指定する 
	public Integer page;

	// 一度のリクエストに含めるレスポンス(非同期ジョブ)の個数を指定する。pageと同時にしていする.(default:500) 
	public Integer pagesize;

	//	タグ情報（key, value）による検索条件を指定する。 
	//	タグ情報は、 
	//	 
	//	 tags[N].key=“sample_key” 
	//	 tags[N].value=“sample_value” 
	//	 （N=0, 1, 2, 3, ….） 
	//	 
	//	の形で指定する 
	public String tags;

	// Disk Volumeのタイプを指定する。 (ROOT / DATADISK)
	public String type;

	// 仮想マシンのidによる検索条件を付与する
	public String virtualmachineid;

	// zone idによる検索条件を付与する
	public String zoneid;
	
	public ListVolumesRequest withId(@NonNull String id) {
		Preconditions.checkNotNull(id);
		this.id = id;
		return this;
	}
	
	public ListVolumesRequest withVirtualMachineId(@NonNull String virtualmachineid) {
		Preconditions.checkNotNull(virtualmachineid);
		this.virtualmachineid = virtualmachineid;
		return this;
	}
}
