/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.factory;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.cloudn.ErrorCode;
import com.clustercontrol.cloud.cloudn.rest.CloudnCompute;
import com.clustercontrol.cloud.cloudn.rest.QueryAsyncJobResultResponse;
import com.clustercontrol.cloud.cloudn.util.CloudnConstants;
import com.clustercontrol.cloud.util.Tuple;
import com.clustercontrol.ws.cloudn.AttachStorageResult;
import com.clustercontrol.ws.cloudn.DeleteInstanceResult;
import com.clustercontrol.ws.cloudn.JobResult;
import com.clustercontrol.ws.cloudn.PasswordResult;

public class CloudnAsynchJobTrackingOperator {
	private static LinkedHashMap<Tuple, JobId> jobIdMap = new LinkedHashMap<Tuple, JobId>();
	
	public static void registJobId(Tuple tuple, String jobId){
		cleanup();
		synchronized(jobIdMap){
			if(jobIdMap.containsKey(tuple)){
				jobIdMap.remove(tuple);
			}
			jobIdMap.put(tuple, new JobId(jobId, new Date()));
		}
	}
	
	public static String findJobId(Tuple tuple) throws CloudManagerFault{
		boolean isAvaillable = true;
		String jobId = null;
		synchronized(jobIdMap){
			if(jobIdMap.containsKey(tuple)){
				if(new Date().getTime() - jobIdMap.get(tuple).getRegistDate().getTime() > CloudnConstants.KEEP_TRACKING_JOB_ID_PERIOD){
					isAvaillable = false;
				} else {
					jobId = jobIdMap.get(tuple).id;
				}
			}
		}
		if(!isAvaillable){
			cleanup();
		}
		if(jobId == null){
			StringBuffer sb = new StringBuffer();
			for(Object o: tuple.toArray()){
				sb.append(o.toString() + " ");
			}
			if(sb.length() >= 1){
				sb.setLength(sb.length() - 1);
			}
			throw ErrorCode.JOB_ID_UNREGISTERED.cloudManagerFault(sb);
		}
		return jobId;
	}
	
	private static void cleanup(){
		synchronized(jobIdMap){
			for(Entry<Tuple, JobId> entry: new LinkedHashMap<Tuple, JobId>(jobIdMap).entrySet()){
				if(new Date().getTime() - entry.getValue().getRegistDate().getTime() >  CloudnConstants.KEEP_TRACKING_JOB_ID_PERIOD){
					jobIdMap.remove(entry.getKey());
				} else {
					break;
				}
			}
		}
	}
	
	public static class JobId{
		private String id;
		private Date registDate;
		public JobId(String id, Date registDate){
			this.id = id;
			this.registDate = registDate;
		}
		public String getId() {return id;}
		public void setId(String id) {this.id = id;}
		public Date getRegistDate() {return registDate;}
		public void setRegistDate(Date registDate) {this.registDate = registDate;}
	}
	
	@SuppressWarnings("unchecked")
	public static <T extends JobResult> T getJobResult(CloudnCompute compute, String jobId, Class<T> clazz) throws CloudManagerFault{
		
		JobResult jobResult = null;
		
		QueryAsyncJobResultResponse response = compute.queryAsyncJobResult(jobId);
		
		if(clazz.equals(PasswordResult.class)){
			PasswordResult result = new PasswordResult();
			if(response.jobresult != null && response.jobresult.virtualmachine != null){
				result.setPassword(response.jobresult.virtualmachine.password);
			}			
			jobResult = result;
		} else
		if(clazz.equals(AttachStorageResult.class)){
			jobResult = new AttachStorageResult();
		} else
		if(clazz.equals(DeleteInstanceResult.class)){
			jobResult = new DeleteInstanceResult();
		} else {
			jobResult = new JobResult(){};
		}
		
		jobResult.setStatusByCode(Integer.parseInt(response.jobstatus));
		
		if(jobResult.getStatus().equals(JobResult.JobStatus.failure)){
			jobResult.setErrorCode(String.valueOf(response.jobresult.errorcode));
			jobResult.setErrorText(response.jobresult.errortext);
		}
		
		return (T) jobResult;
	}
}
