/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.SecurityGroup;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateInstanceDialog_FLAT;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateInstanceDialog_FLAT.DialogControlContainer;
import com.clustercontrol.cloud.cloudn.base.ui.views.actions.CreateInstanceAction_FLAT.InstanceDetail;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.ICloudInstance.StateType;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.presenter.InvalidStateException;
import com.clustercontrol.cloud.presenter.RestoreCloudInstanceRequest;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;


public class RestoreInstanceAction_FLAT extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgRestoreInstanceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.restore"});
	private String msgRestoreInstanceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.restore"});
	private String msgInstanceBackupNotExistOrReady = messages.getString("message.error.instance_backup_is_not_exist_or_ready");

	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateInstanceDialog_FLAT dialog = new CreateInstanceDialog_FLAT(this.viewPart.getSite().getShell());
		
		final ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		final String region = backup.getRegion();
		
		final CloudResourceProvider provider = new CloudResourceProviderImpl(backup.getAccountResourceId());
		dialog.setCloudInfoProvider(provider);

		ObjectMapper om = new ObjectMapper();
		ObjectReader or = om.reader(InstanceDetail.class);
		InstanceDetail detail = null;
		try {
			detail = or.readValue(backup.getBackupedData().getInstanceDetail());
			if(detail.securityGroups != null && !detail.securityGroups.isEmpty()){
				List<SecurityGroup> securityGroups = new ArrayList<>();
				List<SecurityGroup> allSecurityGroups = provider.getSecurityGroups(region);
				for(String securityGroupName: detail.securityGroups){
					for(SecurityGroup securityGroup: new ArrayList<>(allSecurityGroups)){
						if(securityGroup.getName().equals(securityGroupName)){
							securityGroups.add(securityGroup);
							allSecurityGroups.remove(securityGroup);
							break;
						}
					}
				}
				dialog.setSecurityGroups(securityGroups);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		final String group = detail != null? detail.group: null;
		
		Filter f1 = new Filter();
		f1.setName("image-id");
		f1.setValues(Arrays.asList(backup.getInstanceBackupId()));
		Filter f2 = new Filter();
		f2.setName("zone");
		f2.setValues(Arrays.asList(backup.getInstanceBackupId().substring(37)));
		final List<Template> imageList = provider.getTemplates(region, Arrays.asList(f1, f2));
		if(imageList.isEmpty()) {
			throw new InvocationException(msgInstanceBackupNotExistOrReady);
		}
		
		dialog.setBehavior(new CreateInstanceDialog_FLAT.IDialogBehavior(){
			@Override
			public void setup(DialogControlContainer container) {
				container.getFacilityId().setText(backup.getBackupedData().getFacilityId());
				container.getBtnReplaceNode().setSelection(true);
				container.getFacilityName().setText(backup.getBackupedData().getFacilityName());
				container.getDescription().setText(backup.getDescription());
				container.getNodeName().setText(backup.getBackupedData().getNodeName());
				
				if(container.getCmbZone().indexOf(backup.getInstanceBackupId().substring(37)) > -1){
					container.getCmbZone().select(container.getCmbZone().indexOf(backup.getInstanceBackupId().substring(37)));
				} else if(container.getCmbZone().getItemCount() > 0){
					container.getCmbZone().select(0);
				}
				container.getCmbZone().setEnabled(false);
				
				Template image = imageList.get(0);
				container.getTxtVMI().setText(image.getName() + "(" + image.getId() + ") ");
				container.getTxtVMI().setData(image);
				container.getTxtVMI().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				
				if(group != null){
					container.getTxtGroup().setText(group);
				}
				
				container.getTxtVMI().setEditable(false);
				container.getBtnSelectVMI().setEnabled(false);
				
				container.getBtnUseTemplate().setEnabled(false);
				container.getLblTemplate().setEnabled(false);
				container.getCmbTemplate().setEnabled(false);
				container.getBtnEditArgument().setEnabled(false);
				
				container.getBtnAttachingDisk().setVisible(true);
				container.getLblAttachingDisk().setVisible(true);
			}
		});

		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgRestoreInstanceConfirm)){
				
				CreateInstanceDialog_FLAT.Model m = dialog.getOutput();
				
				ICloudComputeService service = backup.getCloudInstanceBackupManager().getRegion().getCloudService(ICloudComputeService.class);
				
				final ICloudInstance instance;
				
				detail = new InstanceDetail();
				if (m.getSecurityGroups() != null) detail.securityGroups.addAll(m.getSecurityGroups());
				detail.group = m.getGroup();
				detail.attachingDisk = m.getAttachingDisk();
				
				ObjectWriter dw = om.writerWithType(InstanceDetail.class);
				String detailJson;
				try {
					detailJson = dw.writeValueAsString(detail);
				} catch (Exception e) {
					throw new CloudModelException(e);
				}
				
				RestoreCloudInstanceRequest request = new RestoreCloudInstanceRequest();
				
				request.setZone(m.getZone());
				request.setInstanceBackupId(m.getImageId());
				request.setFlavor(m.getFlavor());
				
				request.setFacilityId(m.getFacilityId());
				request.setFacilityName(m.getFacilityName());
				request.setDescription(m.getDescription());
				request.setNodeName(m.getNodeName());
				request.setReplaceNode(m.getReplaceNode());
				
				request.setInstanceDetail(detailJson);
				
				request.setTags(m.getTags());
				
				instance = service.getInstanceManager().restoreCloudInstance(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgRestoreInstanceResult);

				// Password を追跡して別ダイアログに表示する
				try {
					JobTrackingService.trackPassword(viewPart, instance);
				} catch (InvalidStateException e) {
						throw new InvocationException(e);
				}
				
				viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, StateType.running, StateType.terminated, StateType.stopped);
						com.clustercontrol.action.FacilityTree.refresh();
					}
				});
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)selection).getFirstElement();
		if(backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudInstanceBackup.RestoreStatus.unavailable.name())){
			action.setEnabled(false);
		}
	}
}