/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.presenter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.soap.SOAPBinding;

import org.eclipse.jface.preference.IPreferenceStore;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.util.LoginManager;

public abstract class EndpointHolder<T> extends ThreadLocal<T> {
	public EndpointHolder() {
		super();
	}

	@SuppressWarnings("unchecked")
	@Override
	protected T initialValue() {
		InvocationHandler h = new InvocationHandler() {
			private String currentUserId;
			private String currentPassword;
			private String currentUrl;

			private T endpoint;

			@Override
			public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
				// 作成済みのエンドポイントが存在するか確認。
				if (endpoint == null) {
					//　エンドポイントが未作成なので、新規に作成。
					String userId = LoginManager.getUserId();
					String password = LoginManager.getPassword();
					String url = LoginManager.getUrl();

					//	    					if (
					//	    						userId != null && !userId.isEmpty() &&
					//	    						password != null && !password.isEmpty() &&
					//	    						url != null && !url.isEmpty()
					//	    						){
					endpoint = createEndpoint(userId, password, url);

					currentUserId = userId;
					currentPassword = password;
					currentUrl = url;
					//	    					}
				}
				else {
					String userId = LoginManager.getUserId();
					String password = LoginManager.getPassword();
					String url = LoginManager.getUrl();
					
					if (userId == null || password == null || url == null) throw new IllegalStateException();
					
					//　過去に作成したエンドポイントのログイン情報と、現在のログイン情報が一致するか確認。
					// TODO つくり的に NullPointerException がスローされるを是としているのでよろしくない。作り直さないと。
					if (!(userId.equals(currentUserId) && password.equals(currentPassword) && url.equals(currentUrl))) {
						// 一致しないので新規に作成。
						endpoint = createEndpoint(userId, password, url);
						currentUserId = userId;
						currentPassword = password;
						currentUrl = url;
					}
				}

				try {
					return method.invoke(endpoint, args);
				}
				catch (InvocationTargetException e) {
					throw e.getCause();
				}
			}
		};
		return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class<?>[]{getEndpointClass()}, h);
	}
	
	protected T createEndpoint(String userId, String password, String url) {
		T endpoint = null;

		try {
			String urlEndpoint = LoginManager.getUrl() + getEndpointServiceClass().getSimpleName();
			
			endpoint = createEndpoint(urlEndpoint);

			BindingProvider bp = (BindingProvider)endpoint;
			bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlEndpoint);
			bp.getRequestContext().put(BindingProvider.USERNAME_PROPERTY, userId);
			bp.getRequestContext().put(BindingProvider.PASSWORD_PROPERTY, password);

			IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
			int httpConnectTimeout = store.getInt(LoginManager.KEY_HTTP_CONNECT_TIMEOUT);
			int httpRequestTimeout = store.getInt(LoginManager.KEY_HTTP_REQUEST_TIMEOUT);
			
			bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", httpConnectTimeout * 1000);
			bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", httpRequestTimeout * 1000);

			((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}

		return endpoint;
	}

	protected abstract Class<T> getEndpointClass();

	protected abstract Class<?> getEndpointServiceClass();
	
	protected abstract String getNamespace();

	@SuppressWarnings("unchecked")
	protected T createEndpoint(String urlEndpoint) throws Exception {
		Object service = getEndpointServiceClass().getConstructor(URL.class, QName.class).newInstance(new URL(urlEndpoint + "?wsdl"), new QName(getNamespace(), getEndpointServiceClass().getSimpleName()));
		
		for (Method method: service.getClass().getDeclaredMethods()) {
			if (method.getAnnotation(WebEndpoint.class) != null && method.getParameterTypes().length == 0 && method.getReturnType() == getEndpointClass()) {
				return (T)method.invoke(service);
			}
		}
		throw new NoSuchMethodException();
	}
}
