/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.util.Messages;

public class CreateTemplateJobDialog extends Dialog {
	public static class DialogOutput{
		private String jobnetId;
		private String jobnetName;
		private TemplateJobUtil.TemplateJobOSType osType;
		private List<TemplateJobUtil.TemplateJob> templateJobList;
		public String getJobnetId() {
			return jobnetId;
		}
		public void setJobnetId(String jobnetId) {
			this.jobnetId = jobnetId;
		}
		public String getJobnetName() {
			return jobnetName;
		}
		public void setJobnetName(String jobnetName) {
			this.jobnetName = jobnetName;
		}
		public TemplateJobUtil.TemplateJobOSType getOsType() {
			return osType;
		}
		public void setOsType(TemplateJobUtil.TemplateJobOSType osType) {
			this.osType = osType;
		}
		public List<TemplateJobUtil.TemplateJob> getTemplateJobList() {
			return templateJobList;
		}
		public void setTemplateJobList(List<TemplateJobUtil.TemplateJob> templateJobList) {
			this.templateJobList = templateJobList;
		}
	}

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strWindows = messages.getString("word.windows");
	private String strJobnetName = messages.getString("word.jobnet_name");
	private String strJobnetId = messages.getString("word.jobnet_id");
	private String strOsType = messages.getString("word.os_type");
	private String strLinux = messages.getString("word.linux");
	private String strJobId = messages.getString("word.job_id");
	private String strJobName = messages.getString("word.job_name");
	private String strOrderNo = messages.getString("word.order_no");
	private String strCommandType = messages.getString("word.command_type");
	private String strExecuteCommnad = messages.getString("word.execute_command");
	private String strBehaviorInFailure = messages.getString("caption.behavior_in_failure");
	private String strExecuteUser = messages.getString("word.execute_user");
	private String strArgument = messages.getString("word.argument");
	private String strAdd = messages.getString("word.add");
	private String strModify = messages.getString("word.modify");
	private String strRemove = messages.getString("word.remove");
	private String strUp = messages.getString("word.up");
	private String strDown = messages.getString("word.down");
	private String msgJobDoesNotExists = messages.getString("message.job_does_not_exists");
	private String msgJobIdOverlaps = messages.getString("message.job_id_overlaps");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String strCreateTemplateJobDialog = messages.getString("caption.create_template_job_dialog");
	
	private Table table;
	private TableViewer tableViewer;

	private Shell shell;
	
	private Text txtJobnetId;
	private Text txtJobnetName;
	private Button rdoWindows;
	private Button rdoLinux;
	
	private List<TemplateJobUtil.TemplateJob> jobInfos = new LinkedList<TemplateJobUtil.TemplateJob>();

	private DialogOutput output;
	
	private String roleId = "";
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateTemplateJobDialog(Shell parentShell){
		super(parentShell);
		shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblTemplateId = new Label(container, SWT.NONE);
		lblTemplateId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTemplateId.setText(strJobnetId + strSeparator);
		
		txtJobnetId = new Text(container, SWT.BORDER);
		txtJobnetId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblJobnetId = new Label(container, SWT.NONE);
		lblJobnetId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblJobnetId.setText(strJobnetName + strSeparator);
		
		txtJobnetName = new Text(container, SWT.BORDER);
		txtJobnetName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label lblOSType = new Label(container, SWT.NONE);
		lblOSType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblOSType.setText(strOsType + strSeparator);
		
		Composite commandTypeComposite = new Composite(container, SWT.NONE);
		GridLayout gl_commandTypeComposite = new GridLayout(3, false);
		commandTypeComposite.setLayout(gl_commandTypeComposite);
		commandTypeComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		rdoWindows = new Button(commandTypeComposite, SWT.RADIO);
		rdoWindows.setText(strWindows);
		
		rdoLinux = new Button(commandTypeComposite, SWT.RADIO);
		rdoLinux.setText(strLinux);
		new Label(commandTypeComposite, SWT.NONE);
		
		Composite jobContainer = new Composite(container, SWT.NONE);
		jobContainer.setBackground(SWTResourceManager.getColor(255, 255, 255));
		GridLayout gl_jobContainer = new GridLayout(2, false);
		jobContainer.setLayout(gl_jobContainer);
		GridData gd_jobContainer = new GridData(GridData.FILL_BOTH);
		gd_jobContainer.horizontalSpan = 2;
		jobContainer.setLayoutData(gd_jobContainer);
		
		table = new Table(jobContainer, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 6));
		
		TableColumn tblclmnOrderNo = new TableColumn(table, SWT.NONE);
		tblclmnOrderNo.setWidth(60);
		tblclmnOrderNo.setText(strOrderNo);

		TableColumn tblclmnJobId = new TableColumn(table, SWT.NONE);
		tblclmnJobId.setWidth(60);
		tblclmnJobId.setText(strJobId);

		TableColumn tblclmnJobName = new TableColumn(table, SWT.NONE);
		tblclmnJobName.setWidth(60);
		tblclmnJobName.setText(strJobName);

		TableColumn tblclmnCommandType = new TableColumn(table, SWT.NONE);
		tblclmnCommandType.setWidth(60);
		tblclmnCommandType.setText(strCommandType);
		
		TableColumn tblclmnCommand = new TableColumn(table, SWT.NONE);
		tblclmnCommand.setWidth(60);
		tblclmnCommand.setText(strExecuteCommnad);
		
		TableColumn tblclmnUser = new TableColumn(table, SWT.NONE);
		tblclmnUser.setWidth(60);
		tblclmnUser.setText(strExecuteUser);
		
		TableColumn tblclmnArgument = new TableColumn(table, SWT.NONE);
		tblclmnArgument.setWidth(60);
		tblclmnArgument.setText(strArgument);

		TableColumn tblclmnBehaviorInFailure = new TableColumn(table, SWT.NONE);
		tblclmnBehaviorInFailure.setWidth(60);
		tblclmnBehaviorInFailure.setText(strBehaviorInFailure);
		
		Button btnAddJob = new Button(jobContainer, SWT.NONE);
		btnAddJob.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		btnAddJob.setText(strAdd);

		Button btnModifyJob = new Button(jobContainer, SWT.NONE);
		btnModifyJob.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		btnModifyJob.setText(strModify);

		Button btnRemoveJob = new Button(jobContainer, SWT.NONE);
		btnRemoveJob.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		btnRemoveJob.setText(strRemove);

		new Label(jobContainer, SWT.NONE);
		
		Button btnUpItem = new Button(jobContainer, SWT.NONE);
		btnUpItem.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		btnUpItem.setText(strUp);

		Button btnDownItem = new Button(jobContainer, SWT.NONE);
		btnDownItem.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		btnDownItem.setText(strDown);
		
		//必須設定
		Control[] requiredControls = new Control[]{
			txtJobnetId,
			txtJobnetName
		};
		ControlUtil.setRequired(requiredControls);

		//初期値
		rdoWindows.setSelection(true);
		
		btnAddJob.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				RegistCommandDialog dialog = new RegistCommandDialog(shell);
				
				dialog.setRoleId(roleId);
				
				if(dialog.open() == Window.OK){
					TemplateJobUtil.TemplateJob tmpJob = dialog.getOutput();
					tmpJob.setOrderNo(jobInfos.size() + 1);
					jobInfos.add(tmpJob);
					tableViewer.setInput(jobInfos);
				}
			}
		});
		
		btnModifyJob.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(tableViewer.getSelection().isEmpty())return;
				if(!(tableViewer.getSelection() instanceof IStructuredSelection))return;
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
				if(selection.size() > 1)return;
				TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)selection.getFirstElement();
				RegistCommandDialog dialog = new RegistCommandDialog(shell);
				dialog.setInput(currentJob);
				
				if(dialog.open() == Window.OK){
					TemplateJobUtil.TemplateJob tmpJob = dialog.getOutput();
					tmpJob.setOrderNo(currentJob.getOrderNo());
					jobInfos.remove(currentJob);
					jobInfos.add(tmpJob);
					sort();
					tableViewer.setInput(jobInfos);
				}
			}
		});

		btnRemoveJob.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(tableViewer.getSelection().isEmpty())return;
				if(!(tableViewer.getSelection() instanceof IStructuredSelection))return;
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
//				if(selection.size() > 1)return;
//				TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)selection.getFirstElement();
				
				for(Object object: selection.toList()){
					TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob) object;
					jobInfos.remove(currentJob);
					
					for(TemplateJobUtil.TemplateJob tmpJob: jobInfos){
						if(currentJob.getOrderNo() < tmpJob.getOrderNo()){
							tmpJob.setOrderNo(tmpJob.getOrderNo() - 1);
						}
					}
				}
				sort();
				tableViewer.setInput(jobInfos);
			}
		});

		btnUpItem.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(tableViewer.getSelection().isEmpty())return;
				if(!(tableViewer.getSelection() instanceof IStructuredSelection))return;
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
//				if(selection.size() > 1)return;
//				TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)selection.getFirstElement();
//				if(currentJob.getOrderNo().equals(1))return;

				int count = 0; //複数行用
				for(Object object: selection.toList()){ //複数行用
					TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob) object; //複数行用
					if(!currentJob.getOrderNo().equals(1 + count)){ //複数行用
						
						for(TemplateJobUtil.TemplateJob tmpJob: jobInfos){
							if(currentJob.getOrderNo().equals(tmpJob.getOrderNo() + 1)){
								tmpJob.setOrderNo(tmpJob.getOrderNo() + 1);
								currentJob.setOrderNo(currentJob.getOrderNo() - 1);
								break;
							}
						}
						
					} //複数行用
					count++; //複数行用
				} //複数行用
				
				sort();
				tableViewer.setInput(jobInfos);
			}
		});

		btnDownItem.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(tableViewer.getSelection().isEmpty())return;
				if(!(tableViewer.getSelection() instanceof IStructuredSelection))return;
				IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
//				if(selection.size() > 1)return;
//				TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)selection.getFirstElement();
//				if(currentJob.getOrderNo().equals(jobInfos.size()))return;
				
				List<TemplateJobUtil.TemplateJob> tmpList = new LinkedList<TemplateJobUtil.TemplateJob>(); //複数行用
				tmpList.clear(); //複数行用
				for(Object object: selection.toList()){ //複数行用
					tmpList.add((TemplateJobUtil.TemplateJob) object); //複数行用
				} //複数行用
				Collections.reverse(tmpList); //複数行用
				int count = 0; //複数行用
				for(TemplateJobUtil.TemplateJob currentJob: tmpList){ //複数行用
					if(!currentJob.getOrderNo().equals(jobInfos.size() - count)){ //複数行用
					
						for(TemplateJobUtil.TemplateJob tmpJob: jobInfos){
							if(currentJob.getOrderNo().equals(tmpJob.getOrderNo() - 1)){
								tmpJob.setOrderNo(tmpJob.getOrderNo() - 1);
								currentJob.setOrderNo(currentJob.getOrderNo() + 1);
								break;
							}
						}
						
					} //複数行用
					count++; //複数行用
				} //複数行用
				
				sort();
				tableViewer.setInput(jobInfos);
			}
		});
		
		tableViewer = new TableViewer(table);

		tableViewer.setContentProvider(new IStructuredContentProvider(){

			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			
			@Override
			public void dispose() {
				
			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
				
			}
		});
				
		tableViewer.setInput(jobInfos);
		tableViewer.setLabelProvider(new TableLabelProvider());
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if(txtJobnetId.getText().equals("") 
			|| txtJobnetName.getText().equals("")
			|| (!rdoWindows.getSelection() && !rdoLinux.getSelection())
		){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}
		
		if(jobInfos.size() < 1){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgJobDoesNotExists);
			return;
		}

		List<TemplateJobUtil.TemplateJob> tmpList = new ArrayList<TemplateJobUtil.TemplateJob>();
		tmpList.clear();
		tmpList.addAll(jobInfos);
		for(TemplateJobUtil.TemplateJob currentJob: jobInfos){
			if(currentJob.getJobId().equals(txtJobnetId.getText())){
				MessageDialog.openError(null,
						Messages.getString("failed"),
						msgJobIdOverlaps);
				return;
			}
			for(TemplateJobUtil.TemplateJob tmpJob: tmpList){
				if(!currentJob.equals(tmpJob) && currentJob.getJobId().equals(tmpJob.getJobId())){
					MessageDialog.openError(null,
							Messages.getString("failed"),
							msgJobIdOverlaps);
					return;
				}
			}
			tmpList.remove(currentJob);
		}
		
		output = new DialogOutput();
		output.setJobnetId(txtJobnetId.getText());
		output.setJobnetName(txtJobnetName.getText());
		if(rdoWindows.getSelection()){
			output.setOsType(TemplateJobUtil.TemplateJobOSType.windows);
		} else if (rdoLinux.getSelection()){
			output.setOsType(TemplateJobUtil.TemplateJobOSType.unix);
		}
		output.setTemplateJobList(jobInfos);
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateTemplateJobDialog);
	}
	
	private static class TableLabelProvider extends LabelProvider implements ITableLabelProvider{

		@Override
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		@Override
		public String getColumnText(Object element, int columnIndex) {
			TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob) element;
			switch(columnIndex){
			case 0:
				return jobInfo.getOrderNo().toString();
			case 1:
				return jobInfo.getJobId();
			case 2:
				return jobInfo.getJobName();
			case 3:
				return jobInfo.getCommandType().name();
			case 4:
				return jobInfo.getCommand();
			case 5:
				if(jobInfo.isUserSpecify()){
					return jobInfo.getExecuteUser();					
				} else {
					return MessageManager.getInstance("messages").getString("word.agent_user");
				}
			case 6:
				return jobInfo.getArgument();
			case 7:
				return jobInfo.getBehaviorInFailure().toString();
			}
			return null;
		}
	}
	
	private void sort(){
		Collections.sort(jobInfos, new Comparator<TemplateJobUtil.TemplateJob>(){
			@Override
			public int compare(TemplateJobUtil.TemplateJob job1, TemplateJobUtil.TemplateJob job2) {
				if(job1.getOrderNo() > job2.getOrderNo()){
					return 1;
				} else if(job1.getOrderNo() < job2.getOrderNo()){
					return -1;
				}
				
				return 0;
			}
		});
	}
	
	public DialogOutput getOutput(){
		return output;
	}

	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}
}
