/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InstanceStateChange;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudInstance extends InternalComponent<CloudInstanceManager, com.clustercontrol.ws.cloud.CloudInstance> implements ICloudInstance {
	private String facilityId;
	private String facilityName;
	private String instanceId;
	private String instanceName;
	private String platform;
	private String cloudTypeId;
	private String region;
	private String zone;
	private String publicDnsName;
	private String state;
	private String registState;
	private String type;
	private String detail;
	private Long regDate;
	private String regUser;
	private Long updateDate;
	private String updateUser;
	
	private List<BlockDeviceMapping> blockDeviceMappings;
	private String cloudUserId;
	private String flavor;
	private String imageId;
	private List<Tag> tags;
	private String templateId;
	
	public CloudInstance(CloudInstanceManager container) {
		super(container);
	}
	
	@Override
	@Export
	public String getFacilityId() {
		return facilityId;
	}
	
	@Import
	public void setFacilityId(String facilityId) {
		internalSet("facilityId", p2.facilityId, facilityId);
	}
	
	@Override
	@Export
	public String getFacilityName() {
		return facilityName;
	}
	
	@Import
	public void setFacilityName(String facilityName) {
		internalSet("facilityName", p2.facilityName, facilityName);
	}
	
	@Override
	@Export
	public String getInstanceId() {
		return instanceId;
	}
	
	@Import
	public void setInstanceId(String instanceId) {
		internalSet("instanceId", p2.instanceId, instanceId);
	}
	
	@Override
	@Export
	public String getInstanceName() {
		return instanceName;
	}
	
	@Import
	public void setInstanceName(String instanceName) {
		internalSet("instanceName", p2.instanceName, instanceName);
	}
	
	@Override
	@Export
	public String getPlatform() {
		return platform;
	}
	
	@Import
	public void setPlatform(String platform) {
		internalSet("platform", p2.platform, platform);
	}
	
	@Override
	@Export
	public String getCloudTypeId() {
		return cloudTypeId;
	}
	
	@Import
	public void setCloudTypeId(String cloudTypeId) {
		internalSet("cloudTypeId", p2.cloudTypeId, cloudTypeId);
	}
	
	@Override
	@Export
	public String getRegion() {
		return region;
	}
	
	@Import
	public void setRegion(String region) {
		internalSet("region", p2.region, region);
	}
	
	@Override
	@Export
	public String getZone() {
		return zone;
	}
	
	@Import
	public void setZone(String zone) {
		internalSet("zone", p2.zone, zone);
	}
	
	@Override
	@Export
	public String getPublicDnsName() {
		return publicDnsName;
	}
	
	@Import
	public void setPublicDnsName(String publicDnsName) {
		internalSet("publicDnsName", p2.publicDnsName, publicDnsName);
	}
	
	@Override
	@Export
	public String getState() {
		return state;
	}
	
	@Import
	public void setState(String state) {
		internalSet("state", p2.state, state);
	}
	
	@Override
	@Export
	public String getRegistState() {
		return registState;
	}
	
	@Import
	public void setRegistState(String registState) {
		internalSet("registState", p2.registState, registState);
	}
	
	@Override
	@Export
	public String getType() {
		return type;
	}
	
	@Import
	public void setType(String type) {
		internalSet("type", p2.type, type);
	}
	
	@Override
	@Export
	public Long getRegDate() {
		return regDate;
	}
	
	@Import
	public void setRegDate(Long regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}
	
	@Override
	@Export
	public String getRegUser() {
		return regUser;
	}
	
	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}
	
	@Override
	@Export
	public Long getUpdateDate() {
		return updateDate;
	}
	
	@Import
	public void setUpdateDate(Long updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}
	
	@Override
	@Export
	public String getUpdateUser() {
		return updateUser;
	}
	
	@Import
	public void setUpdateUser(String updateUser) {
		internalSet("updateUser", p2.updateUser, updateUser);
	}
	
	@Override
	public CloudInstanceManager getCloudInstanceManager() {
		return getContainer();
	}
	
	@Override
	public boolean equalValues(com.clustercontrol.ws.cloud.CloudInstance source) {
		return this.instanceId.equals(source.getInstanceId());
	}
	
	public static CloudInstance createCloudInstance(CloudInstanceManager cloudInstanceManager, com.clustercontrol.ws.cloud.CloudInstance source) {
		CloudInstance cloudInstance = new CloudInstance(cloudInstanceManager);
		cloudInstance.overwrite(source);
		return cloudInstance;
	}

	@Override
	public com.clustercontrol.ws.cloud.CloudInstance getSource() throws CloudModelException {
		try {
			return getEndpoint().getInstance(getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId(), region, instanceId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected void overwrite(com.clustercontrol.ws.cloud.CloudInstance source) {
		ControlUtil.importObject(this, source);
		if(source.getBlockDeviceMappings() != null){
			List<BlockDeviceMapping> list = new ArrayList<BlockDeviceMapping>();
			for(com.clustercontrol.ws.cloud.BlockDeviceMapping wsBlockDeviceMapping: source.getBlockDeviceMappings()){
				list.add(new BlockDeviceMapping(wsBlockDeviceMapping.getStorageId(), wsBlockDeviceMapping.getDeviceName()));
			}
			this.setBlockDeviceMappings(list);
		}
		
		// v202 修正
		if(source.getTags() != null){
			List<Tag> tags = new ArrayList<Tag>();
			for(com.clustercontrol.ws.cloud.Tag tag: source.getTags()){
				tags.add(new Tag(tag.getKey(), tag.getValue()));
			}
			this.setTags(tags);
		}
		
		setCloudTypeId(source.getCloudTypeId());
		setType(source.getFlavor());
		if(source.getState() != null){
			setState(StateType.valueOf(source.getState().value()).label());
		}
		setRegistState(source.getRegistState().value());
	}

	private CloudEndpoint getEndpoint(){
		return this.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}

	private String getRoleId(){
		return getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId();
	}
	
	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		internalSet("detail", p2.detail, detail);
	}

	@Override
	public void start() {
		com.clustercontrol.ws.cloud.StartInstanceRequest request = new com.clustercontrol.ws.cloud.StartInstanceRequest();
		request.setInstanceId(instanceId);
		try {
			InstanceStateChange change = getEndpoint().startInstance(getRoleId(), region, request);
			setState(StateType.valueOf(change.getCurrentState().value()).label());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	@Override
	public void stop() {
		com.clustercontrol.ws.cloud.StopInstanceRequest request = new com.clustercontrol.ws.cloud.StopInstanceRequest();
		request.setInstanceId(instanceId);
		try {
			InstanceStateChange change = getEndpoint().stopInstance(getRoleId(), region, request);
			setState(StateType.valueOf(change.getCurrentState().value()).label());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void registNode(RegistNodeRequest registNodeRequest) {
		com.clustercontrol.ws.cloud.RegistNodeRequest wsRegistNodeRequest = new com.clustercontrol.ws.cloud.RegistNodeRequest();
		com.clustercontrol.ws.cloud.NodeDetail nodeDetail = new com.clustercontrol.ws.cloud.NodeDetail();
		wsRegistNodeRequest.setInstanceId(instanceId);
		RegistNodeRequest request = new RegistNodeRequest();
		ControlUtil.importObject(request, registNodeRequest);
		ControlUtil.exportObject(request, nodeDetail);
		wsRegistNodeRequest.setNodeDetail(nodeDetail);
		
		try {
			com.clustercontrol.ws.cloud.CloudInstance cloudInstance = getEndpoint().registNode(getRoleId(), region, wsRegistNodeRequest);
			overwrite(cloudInstance);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	@Export
	public List<BlockDeviceMapping> getBlockDeviceMappings() {
		return blockDeviceMappings;
	}

	@Import
	public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
		internalSet("blockDeviceMappings", p2.blockDeviceMappings, blockDeviceMappings);
	}

	@Override
	@Export
	public String getCloudUserId() {
		return cloudUserId;
	}

	@Import
	public void setCloudUserId(String cloudUserId) {
		internalSet("cloudUserId", p2.cloudUserId, cloudUserId);
	}

	@Override
	@Export
	public String getFlavor() {
		return flavor;
	}

	@Import
	public void setFlavor(String flavor) {
		internalSet("flavor", p2.flavor, flavor);
	}

	@Override
	@Export
	public String getImageId() {
		return imageId;
	}

	@Import
	public void setImageId(String imageId) {
		internalSet("imageId", p2.imageId, imageId);
	}

	@Override
	@Export
	public List<Tag> getTags() {
		return tags;
	}

	@Import
	public void setTags(List<Tag> tags) {
		internalSet("tags", p2.tags, tags);
	}

	@Override
	@Export
	public String getTemplateId() {
		return templateId;
	}

	@Import
	public void setTemplateId(String templateId) {
		internalSet("templateId", p2.templateId, templateId);
	}

	@Override
	public void attachStorage(String storageId, String device) {
		try {
			getEndpoint().attachStorage(getRoleId(), getRegion(), getInstanceId(), storageId, device);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void detachStorage(String storageId) {
		try {
			getEndpoint().detachStorage(getRoleId(), getRegion(), getInstanceId(), storageId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
	

	@Override
	public void start(RunJobRequest runJobRequest) {
		com.clustercontrol.ws.cloud.StartInstanceRequest request = new com.clustercontrol.ws.cloud.StartInstanceRequest();
		ControlUtil.exportObject(runJobRequest, request);
		convertArguments(request.getArguments(), runJobRequest.getArguments());
		request.setInstanceId(instanceId);
		try {
			InstanceStateChange change = getEndpoint().startInstance(getRoleId(), region, request);
			setState(StateType.valueOf(change.getCurrentState().value()).label());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	@Override
	public void stop(RunJobRequest runJobRequest) {
		com.clustercontrol.ws.cloud.StopInstanceRequest request = new com.clustercontrol.ws.cloud.StopInstanceRequest();
		ControlUtil.exportObject(runJobRequest, request);
		convertArguments(request.getArguments(), runJobRequest.getArguments());
		request.setInstanceId(instanceId);
		try {
			InstanceStateChange change = getEndpoint().stopInstance(getRoleId(), region, request);
			setState(StateType.valueOf(change.getCurrentState().value()).label());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void establishAgentConnection() {
		try {
			getEndpoint().establishAgentConnection(getFacilityId());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	// WebServiceのDTOにListのセット関数がないため、次のシグネチャのメソッドが最もコード冗長性を減らせる。
	// 未使用変数に対するWarningを無視するならばこの限りではない。CliantLocalのリストを受け取りWSDTOのリストを返すメソッドに変更可能。
	private void convertArguments(List<com.clustercontrol.ws.cloud.TemplateJobsArgument> wsArgs, List<TemplateJobsArgument> args){
		if(args != null && args.size() > 0){
			wsArgs.clear(); 
			for(TemplateJobsArgument arg: args){
				com.clustercontrol.ws.cloud.TemplateJobsArgument wsArg = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
				ControlUtil.exportObject(arg, wsArg);
				wsArgs.add(wsArg);
			}
		}
	}
}
