/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Network;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.cloudn.base.ui.views.actions.CreateInstanceAction;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.presenter.InvalidStateException;
import com.clustercontrol.cloud.presenter.RestoreCloudInstanceRequest;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RestoreInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgRestoreInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.restore"});
    private String msgRestoreInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.restore"});
    private String msgInstanceBackupNotExistOrReady = this.messages.getString("message.error.instance_backup_is_not_exist_or_ready");

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        final ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        String region = backup.getRegion();
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(backup.getAccountResourceId());
        dialog.setCloudInfoProvider(provider);
        Filter f1 = new Filter();
        f1.setName("image-id");
        f1.setValues(Arrays.asList(backup.getInstanceBackupId()));
        Filter f2 = new Filter();
        f2.setName("zone");
        f2.setValues(Arrays.asList(backup.getInstanceBackupId().substring(37)));
        final List<Template> imageList = provider.getTemplates(region, Arrays.asList(f1, f2));
        if (imageList.isEmpty()) {
            throw new InvocationException(this.msgInstanceBackupNotExistOrReady);
        }
        dialog.setBehavior(new CreateInstanceDialog.IDialogBehavior(){

            @Override
            public void setup(CreateInstanceDialog.DialogControlContainer container) {
                container.getFacilityId().setText(backup.getBackupedData().getFacilityId());
                container.getBtnReplaceNode().setSelection(true);
                container.getFacilityName().setText(backup.getBackupedData().getFacilityName());
                container.getDescription().setText(backup.getDescription());
                container.getNodeName().setText(backup.getBackupedData().getNodeName());
                if (container.getCmbZone().indexOf(backup.getInstanceBackupId().substring(37)) > -1) {
                    container.getCmbZone().select(container.getCmbZone().indexOf(backup.getInstanceBackupId().substring(37)));
                } else if (container.getCmbZone().getItemCount() > 0) {
                    container.getCmbZone().select(0);
                }
                container.getCmbZone().setEnabled(false);
                Template image = (Template)imageList.get(0);
                container.getTxtVMI().setText(image.getName() + "(" + image.getId() + ") ");
                container.getTxtVMI().setData((Object)image);
                container.getTxtVMI().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                container.getTxtVMI().setEditable(false);
                container.getBtnSelectVMI().setEnabled(false);
                container.getBtnUseTemplate().setEnabled(false);
                container.getLblTemplate().setEnabled(false);
                container.getCmbTemplate().setEnabled(false);
                container.getBtnEditArgument().setEnabled(false);
                ObjectMapper om = new ObjectMapper();
                ObjectReader or = om.reader(CreateInstanceAction.InstanceDetail.class);
                try {
                    CreateInstanceAction.InstanceDetail detail = (CreateInstanceAction.InstanceDetail)or.readValue(backup.getBackupedData().getInstanceDetail());
                    if (!detail.networkIds.isEmpty()) {
                        for (String itemName : container.getCmbNetwork().getItems()) {
                            Network network = (Network)container.getCmbNetwork().getData(itemName);
                            if (!network.getNetworkId().equals(detail.networkIds.get(0))) continue;
                            container.getCmbNetwork().select(container.getCmbNetwork().indexOf(itemName));
                        }
                    }
                    if (detail.group != null) {
                        container.getTxtGroup().setText(detail.group);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                container.getBtnAttachingDisk().setVisible(true);
                container.getLblAttachingDisk().setVisible(true);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgRestoreInstanceConfirm)) {
                String detailJson;
                CreateInstanceDialog.Model m = dialog.getOutput();
                ICloudComputeService service = (ICloudComputeService)backup.getCloudInstanceBackupManager().getRegion().getCloudService(ICloudComputeService.class);
                CreateInstanceAction.InstanceDetail detail = new CreateInstanceAction.InstanceDetail();
                if (m.getNetworkId() != null) {
                    detail.networkIds.add(m.getNetworkId());
                }
                detail.group = m.getGroup();
                detail.attachingDisk = m.getAttachingDisk();
                ObjectMapper om = new ObjectMapper();
                ObjectWriter dw = om.writerWithType(CreateInstanceAction.InstanceDetail.class);
                try {
                    detailJson = dw.writeValueAsString((Object)detail);
                }
                catch (Exception e) {
                    throw new CloudModelException((Throwable)e);
                }
                RestoreCloudInstanceRequest request = new RestoreCloudInstanceRequest();
                request.setZone(m.getZone());
                request.setInstanceBackupId(m.getImageId());
                request.setFlavor(m.getFlavor());
                request.setFacilityId(m.getFacilityId());
                request.setFacilityName(m.getFacilityName());
                request.setDescription(m.getDescription());
                request.setNodeName(m.getNodeName());
                request.setReplaceNode(m.getReplaceNode());
                request.setInstanceDetail(detailJson);
                request.setTags(m.getTags());
                final ICloudInstance instance = service.getInstanceManager().restoreCloudInstance(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRestoreInstanceResult);
                try {
                    JobTrackingService.trackPassword(this.viewPart, instance);
                }
                catch (InvalidStateException e) {
                    throw new InvocationException((Throwable)e);
                }
                this.viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, new ICloudInstance.StateType[]{ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped});
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudInstanceBackup.RestoreStatus.unavailable.name())) {
            action.setEnabled(false);
        }
    }
}

