/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.dialogs.RegistNodeDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RegistNodeAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RegistNodeAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgRegistNodeConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.node", "word.regist"});
    private String msgRegistNodeResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.node", "word.regist"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        RegistNodeDialog dialog = new RegistNodeDialog(this.viewPart.getSite().getShell()){};
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgRegistNodeConfirm + "\n" + instance.getInstanceId()))) {
                RegistNodeDialog.DialogOutput request = dialog.getOutput();
                instance.registNode(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRegistNodeResult);
            } else {
                return;
            }
        }
    }

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return ICloudInstance.RegistStateType.unregistered.name().equals(instance.getRegistState());
    }
}

