/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class RegistCommandDialog
extends Dialog {
    private MessageManager messages = MessageManager.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strJobId = this.messages.getString("word.job_id");
    private String strJobName = this.messages.getString("word.job_name");
    private String strBehaviorInFailure = this.messages.getString("caption.behavior_in_failure");
    private String strExecuteUser = this.messages.getString("word.execute_user");
    private String strArgument = this.messages.getString("word.argument");
    private String strCommand = this.messages.getString("word.command");
    private String strScript = this.messages.getString("word.script");
    private String strRefer = this.messages.getString("word.refer");
    private String strSpecifiedUser = this.messages.getString("word.specified_user");
    private String strAgentUser = this.messages.getString("word.agent_user");
    private String strSuccessReturnRange = this.messages.getString("caption.success_return_range");
    private String msgCommonScriptsDoNotExist = this.messages.getString("message.common_scripts_do_not_exist");
    private String msgInvalidParameterExists = this.messages.getString("message.invalid_parameter_exists");
    private String strRegistCommandDialog = this.messages.getString("caption.regist_command_dialog");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private String msgInvalidDigitOrder = this.messages.getString("message.invalid_digit_order", new Object[]{"\u300c" + this.strSuccessReturnRange + "(1)\u300d", "\u300c" + this.strSuccessReturnRange + "(2)\u300d"});
    private Text txtJobId;
    private Text txtJobName;
    private Text txtArgument;
    private Text txtExecuteUser;
    private Combo cmbBehaviorInFailure;
    private Text txtRangeStart;
    private Text txtRangeEnd;
    private Text txtCommand;
    private Combo cmbScript;
    private Button rdoCommand;
    private Button rdoScript;
    private Button rdoExecBySpecifiedUser;
    private Button rdoExecByLauncher;
    private Button btnUploadScript;
    private TemplateJobUtil.TemplateJob input;
    private TemplateJobUtil.TemplateJob output;
    private String roleId = "";

    public RegistCommandDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        int width;
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 10;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblJobId = new Label(container, 131072);
        lblJobId.setText(this.strJobId + this.strSeparator);
        this.txtJobId = new Text(container, 2048);
        this.txtJobId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblJobName = new Label(container, 131072);
        lblJobName.setText(this.strJobName + this.strSeparator);
        this.txtJobName = new Text(container, 2048);
        this.txtJobName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label(container, 0);
        new Label(container, 0);
        Composite commandTypeComposite = new Composite(container, 0);
        GridLayout gl_commandTypeComposite = new GridLayout(3, false);
        commandTypeComposite.setLayout((Layout)gl_commandTypeComposite);
        commandTypeComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.rdoCommand = new Button(commandTypeComposite, 16);
        this.rdoCommand.setText(this.strCommand);
        this.rdoScript = new Button(commandTypeComposite, 16);
        this.rdoScript.setText(this.strScript);
        new Label(commandTypeComposite, 0);
        Group grpCommand = new Group(container, 0);
        grpCommand.setLayout((Layout)new GridLayout(2, false));
        grpCommand.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpCommand.setText(this.strCommand);
        Label lblCommand = new Label((Composite)grpCommand, 0);
        lblCommand.setText(this.strCommand + this.strSeparator);
        this.txtCommand = new Text((Composite)grpCommand, 2048);
        this.txtCommand.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpScript = new Group(container, 0);
        grpScript.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpScript.setLayout((Layout)new GridLayout(2, false));
        grpScript.setText(this.strScript);
        Label lblScript = new Label((Composite)grpScript, 0);
        lblScript.setText(this.strScript + this.strSeparator);
        this.cmbScript = new Combo((Composite)grpScript, 8);
        GridData gd_cmbScript = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbScript.widthHint = 100;
        this.cmbScript.setLayoutData((Object)gd_cmbScript);
        new Label((Composite)grpScript, 0);
        this.btnUploadScript = new Button((Composite)grpScript, 0);
        this.btnUploadScript.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.btnUploadScript.setText(this.strRefer);
        this.btnUploadScript.setEnabled(false);
        new Label(container, 0);
        new Label(container, 0);
        Label lblArgument = new Label(container, 131072);
        lblArgument.setText(this.strArgument + this.strSeparator);
        this.txtArgument = new Text(container, 2048);
        this.txtArgument.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Group grpExecUser = new Group(container, 0);
        grpExecUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpExecUser.setLayout((Layout)new GridLayout(3, false));
        grpExecUser.setText(this.strExecuteUser);
        this.rdoExecByLauncher = new Button((Composite)grpExecUser, 16);
        this.rdoExecByLauncher.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rdoExecByLauncher.setText(this.strAgentUser);
        this.rdoExecBySpecifiedUser = new Button((Composite)grpExecUser, 16);
        this.rdoExecBySpecifiedUser.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.rdoExecBySpecifiedUser.setText(this.strSpecifiedUser);
        this.txtExecuteUser = new Text((Composite)grpExecUser, 2048);
        this.txtExecuteUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblBehavioreInFailure = new Label(container, 131072);
        lblBehavioreInFailure.setText(this.strBehaviorInFailure + this.strSeparator);
        this.cmbBehaviorInFailure = new Combo(container, 8);
        GridData gd_cmbBehaviorInFailure = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbBehaviorInFailure.widthHint = 100;
        this.cmbBehaviorInFailure.setLayoutData((Object)gd_cmbBehaviorInFailure);
        Label lblSuccessReturnRange = new Label(container, 131072);
        lblSuccessReturnRange.setText(this.strSuccessReturnRange + this.strSeparator);
        Composite rangeComposite = new Composite(container, 0);
        GridLayout gl_rangeComposite = new GridLayout(3, false);
        gl_rangeComposite.marginWidth = 0;
        rangeComposite.setLayout((Layout)gl_rangeComposite);
        rangeComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtRangeStart = new Text(rangeComposite, 2048);
        this.txtRangeStart.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label delimiter = new Label(rangeComposite, 0);
        delimiter.setText("-");
        this.txtRangeEnd = new Text(rangeComposite, 2048);
        this.txtRangeEnd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        container.layout(true);
        int rightColumnStart = this.txtJobId.getBounds().x;
        int leftColumnStart = lblCommand.getBounds().x;
        ((GridData)lblCommand.getLayoutData()).widthHint = width = rightColumnStart - leftColumnStart - 10;
        ((GridData)lblScript.getLayoutData()).widthHint = width;
        container.layout(true);
        Control[] requiredControls = new Control[]{this.txtJobId, this.txtJobName, this.txtCommand, this.cmbScript, this.txtExecuteUser, this.txtRangeStart, this.txtRangeEnd};
        ControlUtil.setRequired(requiredControls);
        Text[] texts = new Text[]{this.txtRangeStart, this.txtRangeEnd};
        ControlUtil.setDigitOnlyInput(texts);
        this.rdoCommand.setSelection(true);
        this.cmbScript.setEnabled(false);
        this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        this.rdoExecByLauncher.setSelection(true);
        this.txtExecuteUser.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        this.txtExecuteUser.setEnabled(false);
        try {
            for (String script : TemplateJobUtil.getTemplateScripts(this.roleId)) {
                this.cmbScript.add(script);
                this.cmbScript.setData(script, (Object)script);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (TemplateJobUtil.BehaviorInFailure behavior : TemplateJobUtil.BehaviorInFailure.values()) {
            this.cmbBehaviorInFailure.add(behavior.toString());
            this.cmbBehaviorInFailure.setData(behavior.toString(), (Object)behavior);
        }
        this.cmbBehaviorInFailure.select(0);
        if (this.input != null) {
            if (this.input.getJobId() != null && !this.input.getJobId().equals("")) {
                this.txtJobId.setText(this.input.getJobId());
            }
            if (this.input.getJobName() != null && !this.input.getJobName().equals("")) {
                this.txtJobName.setText(this.input.getJobName());
            }
            if (this.input.getCommandType() != null && this.input.getCommandType().equals((Object)TemplateJobUtil.CommandType.command)) {
                this.rdoCommand.setSelection(true);
                this.rdoScript.setSelection(false);
                if (this.input.getCommand() != null && !this.input.getCommand().equals("")) {
                    this.txtCommand.setText(this.input.getCommand());
                }
                if (this.txtCommand.getText().equals("")) {
                    this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            } else if (this.input.getCommandType() != null && this.input.getCommandType().equals((Object)TemplateJobUtil.CommandType.script)) {
                this.rdoCommand.setSelection(false);
                this.rdoScript.setSelection(true);
                if (this.input.getCommand() != null && !this.input.getCommand().equals("")) {
                    this.cmbScript.select(this.cmbScript.indexOf(this.input.getCommand()));
                }
                this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                if (this.cmbScript.getText().equals("") || this.cmbScript.indexOf(this.cmbScript.getText()) == -1) {
                    this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
            if (this.input.getArgument() != null && !this.input.getArgument().equals("")) {
                this.txtArgument.setText(this.input.getArgument());
            }
            if (this.input.isUserSpecify() != null && this.input.isUserSpecify().booleanValue()) {
                this.rdoExecByLauncher.setSelection(false);
                this.rdoExecBySpecifiedUser.setSelection(true);
                this.txtExecuteUser.setEnabled(true);
                if (this.input.getExecuteUser() != null && !this.input.getExecuteUser().equals("")) {
                    this.txtExecuteUser.setText(this.input.getExecuteUser());
                } else {
                    this.txtExecuteUser.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                }
            }
            if (this.input.getBehaviorInFailure() != null) {
                this.cmbBehaviorInFailure.select(this.cmbBehaviorInFailure.indexOf(this.input.getBehaviorInFailure().toString()));
            }
            if (this.input.getSuccessRangeStartValue() != null) {
                this.txtRangeStart.setText(this.input.getSuccessRangeStartValue().toString());
            }
            if (this.input.getSuccessRangeEndValue() != null) {
                this.txtRangeEnd.setText(this.input.getSuccessRangeEndValue().toString());
            }
        }
        this.rdoCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistCommandDialog.this.txtCommand.setEnabled(true);
                RegistCommandDialog.this.cmbScript.setEnabled(false);
                if (RegistCommandDialog.this.txtCommand.getText().equals("")) {
                    RegistCommandDialog.this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    RegistCommandDialog.this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                RegistCommandDialog.this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        });
        this.rdoScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RegistCommandDialog.this.cmbScript.getItemCount() < 1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)RegistCommandDialog.this.msgCommonScriptsDoNotExist);
                    RegistCommandDialog.this.rdoScript.setSelection(false);
                    RegistCommandDialog.this.rdoCommand.setSelection(true);
                    return;
                }
                RegistCommandDialog.this.cmbScript.setEnabled(true);
                RegistCommandDialog.this.txtCommand.setEnabled(false);
                RegistCommandDialog.this.txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                if (RegistCommandDialog.this.cmbScript.getText().equals("") || RegistCommandDialog.this.cmbScript.indexOf(RegistCommandDialog.this.cmbScript.getText()) == -1) {
                    RegistCommandDialog.this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    RegistCommandDialog.this.cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        });
        this.rdoExecByLauncher.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistCommandDialog.this.txtExecuteUser.setEnabled(false);
                RegistCommandDialog.this.txtExecuteUser.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        });
        this.rdoExecBySpecifiedUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistCommandDialog.this.txtExecuteUser.setEnabled(true);
                if (RegistCommandDialog.this.txtExecuteUser.getText().equals("")) {
                    RegistCommandDialog.this.txtExecuteUser.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(480, 640);
    }

    protected void okPressed() {
        if (this.txtJobId.getText().equals("") || this.txtJobName.getText().equals("") || !this.rdoCommand.getSelection() && !this.rdoScript.getSelection() || this.rdoCommand.getSelection() && this.txtCommand.getText().equals("") || this.rdoScript.getSelection() && this.cmbScript.getText().equals("") || this.rdoExecBySpecifiedUser.getSelection() && this.txtExecuteUser.getText().equals("") || this.cmbBehaviorInFailure.getText().equals("") || this.txtRangeStart.getText().equals("") || this.txtRangeEnd.getText().equals("")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        if (this.rdoScript.getSelection() && this.cmbScript.getData(this.cmbScript.getText()) == null) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgInvalidParameterExists);
            return;
        }
        try {
            if (Integer.parseInt(this.txtRangeStart.getText()) > Integer.parseInt(this.txtRangeEnd.getText())) {
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgInvalidDigitOrder);
                return;
            }
        }
        catch (NumberFormatException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgInvalidParameterExists);
            return;
        }
        this.output = new TemplateJobUtil.TemplateJob();
        this.output.setJobId(this.txtJobId.getText());
        this.output.setJobName(this.txtJobName.getText());
        if (this.rdoCommand.getSelection()) {
            this.output.setCommandType(TemplateJobUtil.CommandType.command);
            this.output.setCommand(this.txtCommand.getText());
        } else if (this.rdoScript.getSelection()) {
            this.output.setCommandType(TemplateJobUtil.CommandType.script);
            this.output.setCommand((String)this.cmbScript.getData(this.cmbScript.getText()));
        } else {
            throw new IllegalStateException();
        }
        if (!this.txtArgument.getText().equals("")) {
            this.output.setArgument(this.txtArgument.getText());
        }
        if (this.rdoExecByLauncher.getSelection()) {
            this.output.setUserSpecify(false);
        } else {
            this.output.setUserSpecify(true);
            this.output.setExecuteUser(this.txtExecuteUser.getText());
        }
        this.output.setBehaviorInFailure((TemplateJobUtil.BehaviorInFailure)((Object)this.cmbBehaviorInFailure.getData(this.cmbBehaviorInFailure.getText())));
        try {
            this.output.setSuccessRangeStartValue(Integer.parseInt(this.txtRangeStart.getText()));
            this.output.setSuccessRangeEndValue(Integer.parseInt(this.txtRangeEnd.getText()));
        }
        catch (NumberFormatException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgInvalidParameterExists);
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strRegistCommandDialog);
    }

    public void setInput(TemplateJobUtil.TemplateJob input) {
        this.input = input;
    }

    public TemplateJobUtil.TemplateJob getOutput() {
        return this.output;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }
}

