/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.ws.aws;

import java.io.Serializable;

import com.clustercontrol.cloud.bean.Tag;

/**
 * AWS のセキュリティグループ情報を保持するクラス。 
 * 詳細は、以下を参照してください。
 * <a http://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/ec2/model/SecurityGroup.html /> 
 *
 */
public class SecurityGroup implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8898819396696518446L;
	
	private String ownerId;
    private String groupName;
    private String groupId;
    private String description;
    private java.util.List<IpPermission> ipPermissions;
    private java.util.List<IpPermission> ipPermissionsEgress;
    private String vpcId;
    private java.util.List<Tag> tags;

    public String getOwnerId() {
		return ownerId;
	}
	public void setOwnerId(String ownerId) {
		this.ownerId = ownerId;
	}

	public String getGroupName() {
		return groupName;
	}
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getGroupId() {
		return groupId;
	}
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	public java.util.List<IpPermission> getIpPermissions() {
		return ipPermissions;
	}
	public void setIpPermissions(java.util.List<IpPermission> ipPermissions) {
		this.ipPermissions = ipPermissions;
	}

	public java.util.List<IpPermission> getIpPermissionsEgress() {
		return ipPermissionsEgress;
	}
	public void setIpPermissionsEgress(
			java.util.List<IpPermission> ipPermissionsEgress) {
		this.ipPermissionsEgress = ipPermissionsEgress;
	}

	public String getVpcId() {
		return vpcId;
	}
	public void setVpcId(String vpcId) {
		this.vpcId = vpcId;
	}

	public java.util.List<Tag> getTags() {
		return tags;
	}
	public void setTags(java.util.List<Tag> tags) {
		this.tags = tags;
	}
}