/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.commons.util.HinemosProperties;

public enum AWSOptionPropertyConstants implements PropertyContract {
	aws_node_ip("hinemos.cloud.aws.node.ip", qublic, new PropValidator.StringValidator(qublic, qrivate)),
	
	aws_client_config_connectionTimeout("hinemos.cloud.aws.client.config.connectionTimeout", String.valueOf(50 * 1000), PropValidator.intValidator),
	aws_client_config_maxConnections("hinemos.cloud.aws.client.config.maxConnections", String.valueOf(50), PropValidator.intValidator),
	aws_client_config_maxErrorRetry("hinemos.cloud.aws.client.config.maxErrorRetry", String.valueOf(3), PropValidator.intValidator),
	aws_client_config_protocol("hinemos.cloud.aws.client.config.protocol", "https"),
	aws_client_config_proxyDomain("hinemos.cloud.aws.client.config.proxyDomain", null),
	aws_client_config_proxyHost("hinemos.cloud.aws.client.config.proxyHost", null),
	aws_client_config_proxyPassword("hinemos.cloud.aws.client.config.proxyPassword", null),
	aws_client_config_proxyPort("hinemos.cloud.aws.client.config.proxyPort", String.valueOf(-1), PropValidator.intValidator),
	aws_client_config_proxyUsername("hinemos.cloud.aws.client.config.proxyUsername", null),
	aws_client_config_proxyWorkstation("hinemos.cloud.aws.client.config.proxyWorkstation", null),
	aws_client_config_socketTimeout("hinemos.cloud.aws.client.config.socketTimeout", String.valueOf(50 * 1000), PropValidator.intValidator),
	aws_client_config_userAgent("hinemos.cloud.aws.client.config.userAgent", "");
		
	public final String id;
	public final String value;
	public final PropValidator validator;

	private AWSOptionPropertyConstants(String id, String value) {
		this.id = id;
		this.value = value;
		this.validator = null;
	}

	private AWSOptionPropertyConstants(String id, String value, PropValidator validator) {
		this.id = id;
		this.value = value;
		this.validator = validator;
	}
	
	public String value() {
		String prop = HinemosProperties.getProperty(id, value);
		if (validator != null) {
			try {
				validator.validate(prop);
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(AWSOptionPropertyConstants.class);
				logger.error(id + " is invalid("+ prop +"), using default value(" + value + ").");
				prop = value;
			}
		}
		return prop;
	}

	public boolean match(String value) {
		return value().equals(value);
	}

	public String defaultValue() {
		return this.value;
	}
}
