/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import com.clustercontrol.cloud.util.Tuple;

public class CriticalPoint {
	private static Map<Tuple, CriticalPoint> criticalPointMap = new HashMap<>();

	private AtomicInteger syncCount = new AtomicInteger();

	public void enter() {
		syncCount.incrementAndGet();
	}

	public void leave() {
		syncCount.decrementAndGet();
	}

	public boolean isEntering() {
		return syncCount.get() > 0;
	}

	public static synchronized CriticalPoint getCriticalPoint(String accountResourceId, String region) {
		CriticalPoint cp = criticalPointMap.get(Tuple.build(accountResourceId, region));
		if (cp == null) {
			cp = new CriticalPoint();
			criticalPointMap.put(Tuple.build(accountResourceId, region), cp);
		}
		return cp;
	}

	public static synchronized void removeCriticalPoint(String accountResourceId) {
		Iterator<Map.Entry<Tuple, CriticalPoint>> iter = criticalPointMap.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry<Tuple, CriticalPoint> entry = iter.next();
			if (entry.getKey().get(0).equals(accountResourceId)) {
				iter.remove();
			}
		}
	}
}