/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;

import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.persistence.AbstractProcessor;
import com.clustercontrol.cloud.persistence.ProcessedBy;
import com.clustercontrol.cloud.util.CryptionUtil;

@Retention(RetentionPolicy.RUNTIME)  
@Target(ElementType.METHOD)
@ProcessedBy(Cryption.CryptionProcessor.class)
public @interface Cryption {
	public class CryptionProcessor extends AbstractProcessor<Cryption> {
		@Override
		public void preUpdate(Object entity) throws Exception {
			crypt(entity);
		}
		@Override
		public void postUpdate(Object entity) throws Exception {
			decrypt(entity);
		}
		@Override
		public void prePersist(Object entity) throws Exception {
			// EntityManager.persist の呼び出し直後に呼ばれる。
			crypt(entity);
		}
		@Override
		public void postPersist(Object entity) throws Exception {
			// トランザクションのコミット後に、prePersist の entity とは、別のインスタンスが渡ってきて呼ばれる。
			decrypt(entity);
		}
		@Override
		public void postLoad(Object entity) throws Exception {
			decrypt(entity);
		}
		
		private void crypt(Object entity) throws Exception {
			String word = (String)getMethod.invoke(entity);
			Method destSetMethod = entity.getClass().getDeclaredMethod(getSetMethodName(annotation.value()), String.class);
			destSetMethod.invoke(entity, word != null ? CryptionUtil.crypt(word, CloudPropertyConstants.password_crypt_key.value()): null);
		}
		private void decrypt(Object entity) throws Exception {
			Method getGetMethodName = entity.getClass().getDeclaredMethod(getGetMethodName(annotation.value()));
			String word = (String)getGetMethodName.invoke(entity);
			setMethod.invoke(entity, word != null ? CryptionUtil.decrypt(word, CloudPropertyConstants.password_crypt_key.value()): null);
		}
		
		private static String getSetMethodName(String propName) {
			return "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
		}
		private static String getGetMethodName(String propName) {
			return "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
		}
	}
	
	String value();
}