/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

import com.clustercontrol.cloud.persistence.ApplyCurrentTime;
import com.clustercontrol.cloud.persistence.ApplyUserName;


/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_storage_backup")
@IdClass(CloudStorageBackupDao.CloudStorageBackupPK.class)
public class CloudStorageBackupDao extends DaoBase implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2609754609395972304L;

	public enum RestoreStatus {
		available,
		unavailable
	}
	
	public static class CloudStorageBackupPK {
		public String storageBackupId;
		public String region;
		public String accountResourceId;

		public CloudStorageBackupPK() {
		}

		public CloudStorageBackupPK(String storageBackupId, String region, String accountResourceId) {
			this.storageBackupId = storageBackupId;
			this.accountResourceId = accountResourceId;
			this.region = region;
		}

		public String getStorageBackupId() {
			return storageBackupId;
		}

		public String getAccountResourceId() {
			return accountResourceId;
		}

		public String getRegion() {
			return region;
		}

		public void setStorageBackupId(String storageBackupId) {
			this.storageBackupId = storageBackupId;
		}

		public void setAccountResourceId(String accountResourceId) {
			this.accountResourceId = accountResourceId;
		}

		public void setRegion(String region) {
			this.region = region;
		}

		public int hashCode() {
			int _hashCode = 0;
			if (this.storageBackupId != null)
				_hashCode += this.storageBackupId.hashCode();
			if (this.accountResourceId != null)
				_hashCode += this.accountResourceId.hashCode();
			if (this.region != null)
				_hashCode += this.region.hashCode();

			return _hashCode;
		}

		public boolean equals(Object obj) {
			if (!(obj instanceof CloudStorageBackupPK))
				return false;

			CloudStorageBackupPK pk = (CloudStorageBackupPK) obj;
			boolean eq = true;

			if (this.storageBackupId != null) {
				eq = eq && this.storageBackupId.equals(pk.getStorageBackupId());
			} else // this.snapshotId == null
			{
				eq = eq && (pk.getStorageBackupId() == null);
			}
			if (this.accountResourceId != null) {
				eq = eq
						&& this.accountResourceId.equals(pk
								.getAccountResourceId());
			} else // this.cloudAccountId == null
			{
				eq = eq && (pk.getAccountResourceId() == null);
			}
			if (this.region != null) {
				eq = eq && this.region.equals(pk.getRegion());
			} else // this.region == null
			{
				eq = eq && (pk.getRegion() == null);
			}

			return eq;
		}

		public String toString() {
			StringBuffer toStringValue = new StringBuffer("[.");
			toStringValue.append(this.storageBackupId).append('.');
			toStringValue.append(this.accountResourceId).append('.');
			toStringValue.append(this.region).append('.');
			toStringValue.append(']');
			return toStringValue.toString();
		}
	}

	@Embeddable
	public static class BackupedData implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 4522363574206488823L;
		private String storageId;

		public BackupedData() {
		}

		public BackupedData(String storageId, String storageName, Integer storageSize, String zone, String detail) {
			this.storageId = storageId;
		}

		public BackupedData(BackupedData other) {
			this.storageId = other.storageId;
		}

		@Column(name="storage_id")
		public String getStorageId() {
			return storageId;
		}

		public void setStorageId(String storageId) {
			this.storageId = storageId;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result
					+ ((storageId == null) ? 0 : storageId.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			BackupedData other = (BackupedData) obj;
			if (storageId == null) {
				if (other.storageId != null)
					return false;
			} else if (!storageId.equals(other.storageId))
				return false;
			return true;
		}

		@Override
		public String toString() {
			return "BackupedData [storageId=" + storageId + "]";
		}
	}

	private String storageBackupId;
	private String cloudServiceId;
	private String region;
	private String accountResourceId;
	private String snapshotName;
	private String cloudUserId;
	private String description;
	private RestoreStatus restoreStatus;

	private BackupedData backupedData;

	private Timestamp regDate;
	private String regUser;

	public CloudStorageBackupDao()
	{
	}

	public CloudStorageBackupDao(String storageBackupId, String cloudServiceId, String region, String accountResourceId, String snapshotName, String cloudUserId, String description, RestoreStatus restoreStatus, BackupedData backupedData, Timestamp regDate, String regUser) {
		this.storageBackupId = storageBackupId;
		this.cloudServiceId = cloudServiceId;
		this.region = region;
		this.accountResourceId = accountResourceId;
		this.snapshotName = snapshotName;
		this.cloudUserId = cloudUserId;
		this.description = description;
		this.restoreStatus = restoreStatus;
		this.setBackupedData(backupedData);
		this.regDate = regDate;
		this.regUser = regUser;
	}

	public CloudStorageBackupDao(CloudStorageBackupDao other) {
		this.storageBackupId = other.storageBackupId;
		this.cloudServiceId = other.cloudServiceId;
		this.region = other.region;
		this.accountResourceId = other.accountResourceId;
		this.snapshotName = other.snapshotName;
		this.cloudUserId = other.cloudUserId;
		this.description = other.description;
		this.restoreStatus = other.restoreStatus;
		this.setBackupedData(new BackupedData(other.backupedData));
		this.regDate = other.regDate;
		this.regUser = other.regUser;
	}
	
	@Column(name="storage_buckupid_id")
	@Id
	public String getStorageBackupId()
	{
		return this.storageBackupId;
	}
	public void setStorageBackupId( String storageBackupId )
	{
		this.storageBackupId = storageBackupId;
	}

	@Column(name="cloud_Service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}
	
	@Column(name="region")
	@Id
	public String getRegion()
	{
		return this.region;
	}
	public void setRegion( String region )
	{
		this.region = region;
	}

	@Column(name="account_resource_id")
	@Id
	public String getAccountResourceId()
	{
		return this.accountResourceId;
	}
	public void setAccountResourceId( String accountResourceId )
	{
		this.accountResourceId = accountResourceId;
	}

	@Column(name="name")
	public String getSnapshotName()
	{
		return this.snapshotName;
	}
	public void setSnapshotName( String snapshotName )
	{
		this.snapshotName = snapshotName;
	}

	@Column(name="cloud_user_id")
	public String getCloudUserId()
	{
		return this.cloudUserId;
	}
	public void setCloudUserId( String cloudUserId )
	{
		this.cloudUserId = cloudUserId;
	}

	@Column(name="description")
	public String getDescription()
	{
		return this.description;
	}
	public void setDescription( String description )
	{
		this.description = description;
	}

	@Column(name="restore_status")
	@Enumerated(EnumType.STRING)
	public RestoreStatus getRestoreStatus()
	{
		return this.restoreStatus;
	}
	public void setRestoreStatus( RestoreStatus restoreStatus )
	{
		this.restoreStatus = restoreStatus;
	}

	@Embedded
	public BackupedData getBackupedData() {
		return backupedData;
	}

	public void setBackupedData(BackupedData backupedData) {
		this.backupedData = backupedData;
	}
	
	@Column(name="reg_date")
	@ApplyCurrentTime(onlyPersist=true)
	public Timestamp getRegDate()
	{
		return this.regDate;
	}
	public void setRegDate( Timestamp regDate )
	{
		this.regDate = regDate;
	}

	@Column(name="reg_user")
	@ApplyUserName(onlyPersist=true)
	public String getRegUser()
	{
		return this.regUser;
	}
	public void setRegUser( String regUser )
	{
		this.regUser = regUser;
	}

	@Override
	public String toString() {
		return "CloudStorageBackupDao [snapshotId=" + storageBackupId
				+ ", cloudServiceId=" + cloudServiceId + ", region=" + region
				+ ", accountResourceId=" + accountResourceId
				+ ", snapshotName=" + snapshotName + ", cloudUserId="
				+ cloudUserId + ", description=" + description
				+ ", restoreStatus=" + restoreStatus + ", backupedData="
				+ backupedData + ", regDate=" + regDate + ", regUser="
				+ regUser + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudStorageBackupDao other = (CloudStorageBackupDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (backupedData == null) {
			if (other.backupedData != null)
				return false;
		} else if (!backupedData.equals(other.backupedData))
			return false;
		if (cloudServiceId == null) {
			if (other.cloudServiceId != null)
				return false;
		} else if (!cloudServiceId.equals(other.cloudServiceId))
			return false;
		if (cloudUserId == null) {
			if (other.cloudUserId != null)
				return false;
		} else if (!cloudUserId.equals(other.cloudUserId))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (regDate == null) {
			if (other.regDate != null)
				return false;
		} else if (!regDate.equals(other.regDate))
			return false;
		if (regUser == null) {
			if (other.regUser != null)
				return false;
		} else if (!regUser.equals(other.regUser))
			return false;
		if (region == null) {
			if (other.region != null)
				return false;
		} else if (!region.equals(other.region))
			return false;
		if (restoreStatus != other.restoreStatus)
			return false;
		if (storageBackupId == null) {
			if (other.storageBackupId != null)
				return false;
		} else if (!storageBackupId.equals(other.storageBackupId))
			return false;
		if (snapshotName == null) {
			if (other.snapshotName != null)
				return false;
		} else if (!snapshotName.equals(other.snapshotName))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((backupedData == null) ? 0 : backupedData.hashCode());
		result = prime * result
				+ ((cloudServiceId == null) ? 0 : cloudServiceId.hashCode());
		result = prime * result
				+ ((cloudUserId == null) ? 0 : cloudUserId.hashCode());
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((regDate == null) ? 0 : regDate.hashCode());
		result = prime * result + ((regUser == null) ? 0 : regUser.hashCode());
		result = prime * result + ((region == null) ? 0 : region.hashCode());
		result = prime * result
				+ ((restoreStatus == null) ? 0 : restoreStatus.hashCode());
		result = prime * result
				+ ((storageBackupId == null) ? 0 : storageBackupId.hashCode());
		result = prime * result
				+ ((snapshotName == null) ? 0 : snapshotName.hashCode());
		return result;
	}
	
	@Override
	public CloudStorageBackupDao.CloudStorageBackupPK getId() {
		return new CloudStorageBackupDao.CloudStorageBackupPK(getStorageBackupId(), getRegion(), getAccountResourceId());
	}
}
