/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;


/**
 * インスタンスの起動および停止命令後の状態を保持するクラス。
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#startInstance(String,String,StartInstanceRequest) startInstance 関数} および 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#stopInstance(String,String,StopInstanceRequest) stopInstance 関数} から返されます。
 *
 */
public class InstanceStateChange {
	private String instanceId;
	private InstanceStateKind currentState;
	private InstanceStateKind previousState;

	/**
	 * 対象のインスタンス ID を取得する。
	 * 
	 * @return インスタンス ID。
	 */
	public String getInstanceId() {
		return instanceId;
	}
	/**
	 * 対象のインスタンス ID を設定する。
	 * 
	 * @param instanceId インスタンス ID。
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}
	/**
	 * 現在のインスタンスの状態を取得します。
	 * 
	 * @return 現在のインスタンスの状態。
	 */
	public InstanceStateKind getCurrentState() {
		return currentState;
	}

	/**
	 * 現在のインスタンスの状態を設定します。
	 * 
	 * @param currentState 現在のインスタンスの状態。
	 */
	public void setCurrentState(InstanceStateKind currentState) {
		this.currentState = currentState;
	}

	/**
	 * 命令発行前のインスタンスの状態を取得します。
	 * 
	 * @return 命令発行前のインスタンスの状態。
	 */
	public InstanceStateKind getPreviousState() {
		return previousState;
	}

	/**
	 * 命令発行前のインスタンスの状態を設定します。
	 * 
	 * @param previousState 命令発行前のインスタンスの状態。
	 */
	public void setPreviousState(InstanceStateKind previousState) {
		this.previousState = previousState;
	}
}
