/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.cloud;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * リソース取得クラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class MessagesHolder implements IMessagesHolder {
	private ResourceBundle bundle;

	public MessagesHolder(String resourceName) {
		bundle = ResourceBundle.getBundle(resourceName);
	}

	public MessagesHolder(String resourceName, Locale locale) {
		bundle = ResourceBundle.getBundle(resourceName, locale);
	}

	/**
	 * リソースバンドルを返します。
	 * 
	 * @return リソースバンドル
	 */
	public ResourceBundle getBundle() {
		return bundle;
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.cloud.IMessagesHolder#getString(java.lang.String, java.lang.Object)
	 */
	@Override
	public String getString(String key, Object... args) {
		MessageFormat messageFormat = new MessageFormat(getString(key));
		return messageFormat.format(args);
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.cloud.IMessagesHolder#getString(java.lang.String)
	 */
	@Override
	public String getString(String key) {
		try {
			return bundle.getString(key);
		}
		catch (MissingResourceException e) {
			return key;
		}
	}

	/* (non-Javadoc)
	 * @see com.clustercontrol.cloud.IMessagesHolder#getString(java.lang.String, java.lang.String)
	 */
	@Override
	public String getString(String key, String def) {
		try {
			return bundle.getString(key);
		}
		catch (MissingResourceException e) {
			return def;
		}
	}
}