/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.dao.CloudResourceStoreDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.Query;

@Transactional
public class ResourceStore
implements IResourceManagement.IStore {
    private String accountResourceId;
    private String serviceId;
    private String region;

    public ResourceStore(String accountResourceId, String serviceId, String region) {
        this.accountResourceId = accountResourceId;
        this.serviceId = serviceId;
        this.region = region;
    }

    @Override
    public List<IResourceManagement.IStore.StoreValue> getValues(String resourceType) {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query q = em.createQuery("select c from CloudResourceStoreDao c where c.accountResourceId = '" + this.accountResourceId + "' and region = '" + this.region + "' resourceType = " + resourceType);
        List results = q.getResultList();
        ArrayList<IResourceManagement.IStore.StoreValue> values = new ArrayList<IResourceManagement.IStore.StoreValue>();
        for (Object o : results) {
            CloudResourceStoreDao dao = (CloudResourceStoreDao)o;
            values.add(new IResourceManagement.IStore.StoreValue(resourceType, dao.getResourceId(), dao.getValue()));
        }
        return values;
    }

    @Override
    public String get(String resourceType, String resourceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudResourceStoreDao dao = (CloudResourceStoreDao)em.find(CloudResourceStoreDao.class, (Object)new CloudResourceStoreDao.CloudResourceStorePK(resourceId, resourceType, this.region, this.accountResourceId));
        return dao == null ? null : dao.getValue();
    }

    @Override
    public void put(String resourceType, String resourceId, String value) {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudResourceStoreDao dao = new CloudResourceStoreDao(resourceId, resourceType, this.serviceId, this.region, this.accountResourceId, value);
        try {
            em.persist((IDHolder)dao);
        }
        catch (EntityExistsException e) {
            dao = (CloudResourceStoreDao)em.find(CloudResourceStoreDao.class, (Object)dao.getId());
            dao.setValue(value);
        }
    }

    @Override
    public void remove(String resourceType, String resourceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudResourceStoreDao dao = (CloudResourceStoreDao)em.find(CloudResourceStoreDao.class, (Object)new CloudResourceStoreDao.CloudResourceStorePK(resourceId, resourceType, this.region, this.accountResourceId));
        if (dao == null) {
            throw ErrorCode.RESOURCESTORE_NOT_FOUND.cloudManagerFault(resourceId, resourceType, this.region, this.accountResourceId);
        }
        em.remove((Object)dao);
    }

    @Override
    public List<String> getIds(String resourceType) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query q = em.createQuery("SELECT c.resourceId FROM CloudResourceStoreDao c WHERE c.accountResourceId = :accountResourceId AND c.region = :region AND c.resourceType = :resourceType");
        q.setParameter("accountResourceId", (Object)this.accountResourceId);
        q.setParameter("region", (Object)this.region);
        q.setParameter("resourceType", (Object)resourceType);
        return q.getResultList();
    }
}

