/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;


import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudTemplate extends InternalComponent<CloudTemplateManager, com.clustercontrol.ws.cloud.CloudTemplate> implements ICloudTemplate {
    private String accountResourceId;
    private String cloudTypeId;
    private String cloudUserId;
    private String templateId;
    private String templateName;
    private String imageId;
    private String region;
    private String jobUnitId;
    private String launchJobId;
    private String startJobId;
    private String stopJobId;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;

    
	public CloudTemplate(CloudTemplateManager container) {
		super(container);
	}
	
	@Override
	@Export
	public String getTemplateId() {
		return templateId;
	}
	
	@Import
	public void setTemplateId(String templateId) {
		internalSet("templateId", p2.templateId, templateId);
	}
	
	@Override
	@Export
	public String getTemplateName() {
		return templateName;
	}
	
	@Import
	public void setTemplateName(String templateName) {
		internalSet("templateName", p2.templateName, templateName);
	}
	
	@Override
	@Export
	public String getImageId() {
		return imageId;
	}
	
	@Import
	public void setImageId(String imageId) {
		internalSet("imageId", p2.imageId, imageId);
	}

	@Override
	@Export
	public String getLaunchJobId() {
		return launchJobId;
	}
	
	@Import
	public void setLaunchJobId(String launchJobId) {
		internalSet("launchJobId", p2.launchJobId, launchJobId);
	}

	@Override
	@Export
	public String getRegion() {
		return region;
	}
	
	@Import
	public void setRegion(String region) {
		internalSet("region", p2.region, region);
	}

	@Override
	@Export
	public Long getRegDate() {
		return regDate;
	}
	
	@Import
	public void setRegDate(Long regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}
	
	@Override
	@Export
	public String getRegUser() {
		return regUser;
	}
	
	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}

	@Override
	@Export
	public Long getUpdateDate() {
		return updateDate;
	}
	
	@Import
	public void setUpdateDate(Long updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}
	
	@Override
	@Export
	public String getUpdateUser() {
		return updateUser;
	}
	
	@Import
	public void setUpdateUser(String updateUser) {
		internalSet("updateUser", p2.updateUser, updateUser);
	}

	@Override
	@Export
	public String getCloudUserId() {
		return cloudUserId;
	}

	@Import
	public void setCloudUserId(String cloudUserId) {
		internalSet("cloudUserId", p2.cloudUserId, cloudUserId);
	}

	@Override
	@Export
	public String getStartJobId() {
		return startJobId;
	}

	@Import
	public void setStartJobId(String startJobId) {
		internalSet("startJobId", p2.startJobId, startJobId);
	}

	@Override
	@Export
	public String getStopJobId() {
		return stopJobId;
	}

	@Import
	public void setStopJobId(String stopJobId) {
		internalSet("stopJobId", p2.stopJobId, stopJobId);
	}

	@Override
	@Export
	public String getJobUnitId() {
		return jobUnitId;
	}

	@Import
	public void setJobUnitId(String jobUnitId) {
		internalSet("jobUnitId", p2.jobUnitId, jobUnitId);
	}

	@Override
	@Export
	public String getAccountResourceId() {
		return accountResourceId;
	}

	@Import
	public void setAccountResourceId(String accountResourceId) {
		internalSet("accountResourceId", p2.accountResourceId, accountResourceId);
	}

	@Override
	@Export
	public String getCloudTypeId() {
		return cloudTypeId;
	}

	@Import
	public void setCloudTypeId(String cloudTypeId) {
		internalSet("cloudTypeId", p2.cloudTypeId, cloudTypeId);
	}

	@Override
	public CloudTemplateManager getCloudTemplateManager() {
		return getContainer();
	}
	
	@Override
	public boolean equalValues(com.clustercontrol.ws.cloud.CloudTemplate source) {
		return getTemplateId().equals(source.getTemplateId());
	}
	
	public static CloudTemplate createCloudTemplate(CloudTemplateManager cloudInstanceManager, com.clustercontrol.ws.cloud.CloudTemplate source) {
		CloudTemplate cloudInstance = new CloudTemplate(cloudInstanceManager);
		cloudInstance.overwrite(source);
		return cloudInstance;
	}

	@Override
	public com.clustercontrol.ws.cloud.CloudTemplate getSource() throws CloudModelException {
		try {
			return getEndpoint().getTemplate(getRoleId(), getTemplateId());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected void overwrite(com.clustercontrol.ws.cloud.CloudTemplate source) {
		ControlUtil.importObject(this, source);
		setCloudTypeId(internalGetCloudTypeId());
	}

	private CloudEndpoint getEndpoint(){
		return this.getCloudTemplateManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
	
	private String internalGetCloudTypeId(){
		String cloudServiceId = getCloudTemplateManager().getAccountResource().getCloudServiceId();
		String cloudTypeId = getCloudTemplateManager().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
		return cloudTypeId;
	}
	
	private String getRoleId(){
		return getCloudTemplateManager().getAccountResource().getActiveUser().getRoleId();
	}

	@Override
	public void modifyCloudTemplate(ModifyCloudTemplateRequest modifyCloudTemplateRequest) {
		com.clustercontrol.ws.cloud.ModifyTemplateRequest wsRequest = new com.clustercontrol.ws.cloud.ModifyTemplateRequest();
		ModifyCloudTemplateRequest request = new ModifyCloudTemplateRequest();
		ControlUtil.importObject(request, modifyCloudTemplateRequest);
		ControlUtil.exportObject(request, wsRequest);
		try {
			com.clustercontrol.ws.cloud.CloudTemplate modifiedTemplate = getEndpoint().modifyTemplate(getRoleId(), wsRequest);
			overwrite(modifiedTemplate);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
}
