/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.AccountResourceManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudUser;
import com.clustercontrol.cloud.presenter.CreateCloudUserRequest;
import com.clustercontrol.cloud.presenter.ICloudUserManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.List;

public class CloudUserManager
extends InternalContainer<CloudUser, com.clustercontrol.ws.cloud.CloudUser>
implements ICloudUserManager {
    private AccountResource accountResource;

    public CloudUserManager(AccountResource accountResource) {
        this.accountResource = accountResource;
    }

    @Override
    public CloudUser getCloudUser(String cloudUserId) {
        for (CloudUser cloudUser : this.getComponents()) {
            if (!cloudUser.getCloudUserId().equals(cloudUserId)) continue;
            return cloudUser;
        }
        return null;
    }

    private List<CloudUser> getUsersList() {
        if (!this.isInitialized()) {
            this.update();
        }
        return this.getComponents();
    }

    public CloudUser[] getCloudUsers() {
        return this.getComponents().toArray(new CloudUser[this.getComponents().size()]);
    }

    @Override
    public CloudUser createCloudUser(CreateCloudUserRequest createCloudUserRequest) {
        com.clustercontrol.ws.cloud.CreateCloudUserRequest wsCreateCloudUserRequest = new com.clustercontrol.ws.cloud.CreateCloudUserRequest();
        ControlUtil.exportObject(createCloudUserRequest, wsCreateCloudUserRequest);
        try {
            com.clustercontrol.ws.cloud.CloudUser reWsCloudUser = this.getEndpoint().addCloudUser(wsCreateCloudUserRequest);
            CloudUser cloudUser = new CloudUser(this);
            ControlUtil.importObject(cloudUser, reWsCloudUser);
            cloudUser.setCloudUserType(reWsCloudUser.getCloudUserType().name());
            this.getUsersList().add(cloudUser);
            this.fireElementAdded(ICloudUserManager.p2.cloudUsers, cloudUser);
            return cloudUser;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeCloudUser(String cloudUserId) {
        try {
            this.getEndpoint().removeCloudUser(cloudUserId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        CloudUser cloudUser = this.getCloudUser(cloudUserId);
        this.getUsersList().remove(cloudUser);
        this.fireElementRemoved(ICloudUserManager.p2.cloudUsers, cloudUser);
    }

    @Override
    public AccountResource getAccountResource() {
        return this.accountResource;
    }

    @Override
    protected List<com.clustercontrol.ws.cloud.CloudUser> getSources() throws CloudModelException {
        try {
            return this.getEndpoint().getCloudUsersByAccountResource(this.getAccountResource().getAccountResourceId());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected CloudUser createComponent(com.clustercontrol.ws.cloud.CloudUser source) throws CloudModelException {
        CloudUser cloudUser = new CloudUser(this);
        cloudUser.overwrite(source);
        return cloudUser;
    }

    @Override
    protected void fireComponentAdded(CloudUser addedValue) {
        this.fireElementAdded(ICloudUserManager.p2.cloudUsers, addedValue);
    }

    @Override
    protected void fireComponentRemoved(CloudUser removedValue) {
        this.fireElementRemoved(ICloudUserManager.p2.cloudUsers, removedValue);
    }

    private CloudEndpoint getEndpoint() {
        return ((AccountResourceManager)this.getAccountResource().getContainer()).getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }
}

