/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.IFacility;
import com.clustercontrol.cloud.ui.dialogs.ChangeActiveCloudUserDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.AvailableRole;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;

public class AccountControlUtil {
    public static String getRoleId(String accountResourceId) {
        return AccountControlUtil.getAccountResource(accountResourceId).getActiveUser().getRoleId();
    }

    public static List<String> getOwnerRoleIdList() {
        try {
            return AccountControlUtil.getEndpoint(AccessEndpoint.class).getOwnerRoleIdList();
        }
        catch (InvalidRole_Exception e1) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(Messages.getString((String)"message.hinemos.failure.unexpected") + ", " + e1.getMessage()));
        }
        return null;
    }

    public static List<AvailableRole> getAssignableRoles() {
        try {
            return AccountControlUtil.getEndpoint(CloudEndpoint.class).getAvailableRoles();
        }
        catch (CloudManagerFault_Exception | com.clustercontrol.ws.cloud.InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e.getMessage(), e);
        }
    }

    private static <E> E getEndpoint(Class<E> clazz) {
        return Activator.getEndpointManager().getEndpoint(clazz);
    }

    public static Map<String, String> getAllCloudUsersRoleMap() {
        ArrayList<ICloudUser> cloudUsers = new ArrayList<ICloudUser>();
        for (IAccountResource accountResource : Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResources()) {
            cloudUsers.addAll(Arrays.asList(accountResource.getCloudUserManager().getCloudUsers()));
        }
        HashMap<String, String> cloudUsersRoleMap = new HashMap<String, String>();
        for (ICloudUser cloudUser : cloudUsers) {
            cloudUsersRoleMap.put(cloudUser.getCloudUserId(), cloudUser.getRoleId());
        }
        return cloudUsersRoleMap;
    }

    public static Map<String, String> getCloudUsersRoleMapByAccountResource(String accountResourceId) {
        IAccountResource accountResource = AccountControlUtil.getAccountResource(accountResourceId);
        ArrayList<ICloudUser> cloudUsers = new ArrayList<ICloudUser>(Arrays.asList(accountResource.getCloudUserManager().getCloudUsers()));
        HashMap<String, String> cloudUsersRoleMap = new HashMap<String, String>();
        for (ICloudUser cloudUser : cloudUsers) {
            cloudUsersRoleMap.put(cloudUser.getCloudUserId(), cloudUser.getRoleId());
        }
        return cloudUsersRoleMap;
    }

    public static IAccountResource getAccountResource(String accountResourceId) {
        return Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(accountResourceId);
    }

    public static Boolean isInitializedActiveUser(String accountResourceId) throws CloudModelException, NotFoundAccountResourceException {
        IAccountResource accountResource = AccountControlUtil.getAccountResource(accountResourceId);
        if (accountResource != null) {
            if (accountResource.getActiveUser() == null) {
                List<ICloudUser> cloudUsers = AccountControlUtil.getAvailableCloudUsers(accountResourceId);
                if (cloudUsers.size() == 0) {
                    throw new CloudModelException("available cloudUser is empty");
                }
                if (cloudUsers.size() == 1) {
                    accountResource.setActiveUser(cloudUsers.get(0));
                    return true;
                }
                if (accountResource.getAccountId() != null && !accountResource.getAccountId().isEmpty()) {
                    Iterator<ICloudUser> i$ = cloudUsers.iterator();
                    if (i$.hasNext()) {
                        ICloudUser cloudUser = i$.next();
                        if (cloudUser.getCloudUserId().equals(accountResource.getAccountId())) {
                            accountResource.setActiveUser(cloudUser);
                            return true;
                        }
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        throw new NotFoundAccountResourceException();
    }

    public static List<ICloudUser> getAvailableCloudUsers(String accountResourceId) {
        List<ICloudUser> cloudUsers = Arrays.asList(AccountControlUtil.getAccountResource(accountResourceId).getCloudUserManager().getCloudUsers());
        ArrayList<ICloudUser> tmpCloudUsers = new ArrayList<ICloudUser>();
        List<String> ownerRoleIds = AccountControlUtil.getOwnerRoleIdList();
        block0: for (ICloudUser cloudUser : cloudUsers) {
            for (String ownerRoleId : new ArrayList<String>(ownerRoleIds)) {
                if (!cloudUser.getRoleId().equals(ownerRoleId)) continue;
                tmpCloudUsers.add(cloudUser);
                ownerRoleIds.remove(ownerRoleId);
                continue block0;
            }
        }
        return tmpCloudUsers;
    }

    public static Boolean selectActiveUser(IViewPart viewPart) throws NotFoundAccountResourceException {
        MessageManager bundle_messages = MessageManager.getInstance("messages");
        IStructuredSelection selection = (IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection();
        final IFacility facility = (IFacility)selection.getFirstElement();
        final IAccountResource accountResource = AccountControlUtil.getAccountResource(facility.getAccountResourceId());
        ChangeActiveCloudUserDialog dialog = new ChangeActiveCloudUserDialog(viewPart.getSite().getShell());
        dialog.setBehavior(new ChangeActiveCloudUserDialog.DialogBehavior(){

            @Override
            public void setupAccountResource(Text txtAccountResource) {
                super.setupAccountResource(txtAccountResource);
                txtAccountResource.setText(accountResource.getAccountResourceId());
            }

            @Override
            public void setupCloudUser(Combo cmbCloudUser) {
                for (ICloudUser cloudUser : AccountControlUtil.getAvailableCloudUsers(facility.getAccountResourceId())) {
                    String label = cloudUser.getCloudUserName() + "(" + cloudUser.getCloudUserId() + ")";
                    cmbCloudUser.add(label);
                    cmbCloudUser.setData(label, (Object)cloudUser);
                }
                if (accountResource.getActiveUser() != null && cmbCloudUser.indexOf(accountResource.getActiveUser().getCloudUserName() + "(" + accountResource.getActiveUser().getCloudUserId() + ")") != -1) {
                    cmbCloudUser.select(cmbCloudUser.indexOf(accountResource.getActiveUser().getCloudUserName() + "(" + accountResource.getActiveUser().getCloudUserId() + ")"));
                } else if (cmbCloudUser.getItemCount() > 0) {
                    cmbCloudUser.select(0);
                }
            }
        });
        if (dialog.open() == 0 && MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)bundle_messages.getString("message.change_active_cloud_user_confirm"))) {
            ChangeActiveCloudUserDialog.DialogOutput output = dialog.getOutput();
            accountResource.setActiveUser(output.getCloudUser());
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)bundle_messages.getString("message.change_active_cloud_user_result"));
        }
        return AccountControlUtil.isInitializedActiveUser(accountResource.getAccountResourceId());
    }

    public static class NotFoundAccountResourceException
    extends Exception {
        private static final long serialVersionUID = -8532898225608136194L;

        public NotFoundAccountResourceException() {
            super("accountResource is null");
        }
    }
}

