#!/bin/bash

cc_collector_sub_platform_mst_data="\
('cloudn_flat','Cloudn Flat','Cloud','111'),\
('cloudn_vpc','Cloudn VPC','Cloud','112')"

cc_cloud_type_mst_data="\
('cloudn_flat','Cloudn Flat','Cloudn Flat'),\
('cloudn_vpc','Cloudn VPC','Cloudn VPC')"

cc_cloud_service_data="\
('cloudn_flat','BizHosting Cloudn Flat type','cloudn_flat','http://www.ntt.com/cloudn/',null,null,'',''),\
('cloudn_vpc','BizHosting Cloudn VPC OpenNW type','cloudn_vpc','http://www.ntt.com/cloudn/',null,null,'','')" 

cc_cloud_region_data="\
('jp-e1','cloudn_flat','East Japan','East Japan DC'),\
('jp-e1','cloudn_vpc','East Japan','East Japan DC')"

cc_cloud_endpoint_data="\
('compute','cloudn_flat','jp-e1','comp-api.jp-e1.cloudn-service.com/client/api'),\
('compute','cloudn_vpc','jp-e1','vpcopennw-api.jp-e1.cloudn-service.com/client/api')"

if [ ! $(printenv PGPASSWORD) ] ; then
	read -s -p 'Password for user hinemos: ' PASSWD
	if [ "${PASSWD}" != "" ] ; then
	    export PGPASSWORD=${PASSWD}
	fi
	echo
fi

${HINEMOS_HOME}/postgresql/bin/psql -p 24001 -U hinemos -v operation=${1} << EOF >> /dev/null
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;
SET search_path = public,pg_catalog;

`cat ${SCRIPT_DIR}/scripts/cloudn_data_create_maint.sql`

select cloud_maint_operation(
	:'operation',
	CAST(ARRAY[${cc_collector_sub_platform_mst_data}] AS cc_collector_sub_platform_mst[]),
	CAST(ARRAY[${cc_cloud_type_mst_data}] AS cc_cloud_type_mst[]),
	CAST(ARRAY[${cc_cloud_service_data}] AS cc_cloud_service[]),
	CAST(ARRAY[${cc_cloud_region_data}] AS cc_cloud_region[]),
	CAST(ARRAY[${cc_cloud_endpoint_data}] AS cc_cloud_endpoint[])
	);

`cat ${SCRIPT_DIR}/scripts/cloudn_data_drop_maint.sql`
EOF