/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util.proxy;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.registry.ObjectRegistryService;

public class ProxyAuthenticator {
	private static class CloudOptinAuthenticator extends Authenticator {
		public CloudOptinAuthenticator() {
		}
		
		protected PasswordAuthentication getPasswordAuthentication() {
			IProxyStore store = ObjectRegistryService.registry().get(IProxyStore.class);
			com.clustercontrol.cloud.util.proxy.Proxy p = store.getProxy(getRequestingURL().getHost());
			if (p != null)
				return new PasswordAuthentication(p.getUser(), p.getPassword().toCharArray());
			return null;
		}
	}

	private static class CloudOptinProxySelector extends ProxySelector {
		private final ProxySelector defaultSelector;

		public CloudOptinProxySelector(ProxySelector defaultSelector) {
			this.defaultSelector = defaultSelector;
		}
		
		@Override
		public List<Proxy> select(URI uri) {
			IProxyStore store = ObjectRegistryService.registry().get(IProxyStore.class);
			com.clustercontrol.cloud.util.proxy.Proxy p = store.getProxy(uri.getHost());
			if (p != null) {
				if (!("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) throw new InternalManagerError(new UnknownHostException(uri.toString()));
				Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(p.getHost(), p.getPort()));
				return Arrays.asList(proxy);
			}
			else {
				return defaultSelector.select(uri);
			}
		}
		@Override
		public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
		}
	}
	
	public static void setup() {
		ProxySelector.setDefault(new CloudOptinProxySelector(ProxySelector.getDefault()));
		Authenticator.setDefault(new CloudOptinAuthenticator());
	}
}
