//package com.clustercontrol.cloud.factory;
//
//import java.util.concurrent.Callable;
//
//import org.apache.log4j.Logger;
//
//import com.clustercontrol.cloud.CloudManagerFault;
//import com.clustercontrol.cloud.Messages;
//import com.clustercontrol.cloud.commons.CloudPropertyConstants;
//import com.clustercontrol.cloud.factory.TemplateJobOperator.InternalEventNotifier;
//import com.clustercontrol.hinemosagent.util.AgentConnectUtil;
//
//public class AgentUtil {
//	
//	private AgentUtil() {
//	}
//
//	public static void registAgent(final String facilityId){
//		Thread thread = new Thread(new Runnable(){
//			@Override
//			public void run() {
//				Logger logger = Logger.getLogger(TemplateJobOperator.class);
//				try {
//					int counter = 0;
//					int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
//					long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
//					
//					for(;;){
//						logger.debug("It tries to regist agent " + facilityId + " " + ++counter + "/" + maxCount + " time.");
//						
//						// 別のスレッドで、エージェントを登録している可能性があるので、チェックする。
//						if(AgentConnectUtil.sendManagerDiscoveryInfo(facilityId)){
//							return;
//						}
//
//						if(maxCount != 0 && counter >= maxCount){
//							throw new CloudManagerFault("It timed out. Target agent doesn't exist.");
//						}
//						Thread.sleep(interval);
//					}
//				} catch (Exception e) {
//					logger.error(e.getMessage(), e);
//				}
//			}
//		});
//		thread.start();
//	}
//	
//	public static Boolean registAgentObserve(String facilityId) throws CloudManagerFault{
//		Logger logger = Logger.getLogger(TemplateJobOperator.class);
//		try {
//			int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
//			long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
//			
//			boolean connected = false;
//			for (int counter = 0; counter < maxCount; ++counter) {
//				// 別のスレッドで、エージェントを登録している可能性があるので、チェックする。
//				if (AgentConnectUtil.isValidAgent(facilityId)) {
//					return true;
//				}
//				
//				if (!connected) {
//					logger.debug("ping " + facilityId + " " + counter + "/" + maxCount + " time.");
//					connected = AgentConnectUtil.sendManagerDiscoveryInfo(facilityId);
//				}
//
//				Thread.sleep(interval);
//			}
//
//			if (connected && AgentConnectUtil.isValidAgent(facilityId)) {
//				return true;
//			}
//			
//			new InternalEventNotifier("AGT_CONNECTION", facilityId, Messages.getString("cloud.template.message.agent_connection.error_message")).call();
//
//			throw new CloudManagerFault("It timed out. Target agent doesn't exist.");
//		} 
//		catch (Exception e) {
//			Callable<Boolean> internalEventNotifier = ;
//			try {
//				internalEventNotifier.call();
//			}
//			catch(Exception e1) {
//				
//			}
//			
//			throw new CloudManagerFault(e);
//		}
//	}
//
//	public static Boolean findAgentObserve(String facilityId) throws CloudManagerFault{
//		Logger logger = Logger.getLogger(TemplateJobOperator.class);
//		try {
//			int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
//			long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
//			
//			int counter = 0;
//			for(;;){
//				counter++;
//				logger.debug("It tries to find agent " + facilityId + " " + ++counter + "/" + maxCount + " time.");
//				
//				if(AgentConnectUtil.isValidAgent(facilityId)){
//					return true;
//				}
//				
//				if(maxCount != 0 && counter >= maxCount){
//					throw new CloudManagerFault("It timed out. Target agent doesn't exist.");
//				}
//				Thread.sleep(interval);
//			}
//		} catch (Exception e) {
//			throw new CloudManagerFault(e);
//		}
//	}
//}
