/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

public class ActionMode {
	public static enum ActionKind {
		Normal,
		AutoDetection;
	}
	
	private static ThreadLocal<ActionKind> current = new ThreadLocal<ActionKind>() {
		public ActionKind initialValue() {
			return ActionKind.Normal;
		}
	};
	
	private ActionMode() {
	}
	
	public static void enterAutoDetection() {
		current.set(ActionKind.AutoDetection);
	}
	
	public static boolean isAutoDetection() {
		return current.get().equals(ActionKind.AutoDetection);	
	}
	
	public static void leaveAutoDetection() {
		current.set(ActionKind.Normal);
	}
}
