/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_storage")
@IdClass(CloudStorageDao.CloudStoragePK.class)
public class CloudStorageDao extends HinemosObjectDao {
	public static enum StorageStatus {
		exist,
		deleted
	}
	
	public static class CloudStoragePK implements java.io.Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = -4285824256036506413L;
		
		public String storageId;
		public String accountResourceId;
		public String region;

		public CloudStoragePK() {
		}

		public CloudStoragePK(String storageId, String region, String accountResourceId) {
			this.storageId = storageId;
			this.accountResourceId = accountResourceId;
			this.region = region;
		}

		public String getStorageId() {
			return storageId;
		}

		public String getAccountResourceId() {
			return accountResourceId;
		}

		public String getRegion() {
			return region;
		}

		public void setStorageId(String storageId) {
			this.storageId = storageId;
		}

		public void setAccountResourceId(String cloudAccountId) {
			this.accountResourceId = cloudAccountId;
		}

		public void setRegion(String region) {
			this.region = region;
		}

		public int hashCode() {
			int _hashCode = 17;
			if (this.storageId != null)
				_hashCode += this.storageId.hashCode();
			if (this.accountResourceId != null)
				_hashCode += this.accountResourceId.hashCode();
			if (this.region != null)
				_hashCode += this.region.hashCode();

			return _hashCode;
		}

		public boolean equals(Object obj) {
			if (!(obj instanceof CloudStoragePK))
				return false;

			CloudStoragePK pk = (CloudStoragePK) obj;
			boolean eq = true;

			if (this.storageId != null) {
				eq = eq && this.storageId.equals(pk.getStorageId());
			} else // this.storageId == null
			{
				eq = eq && (pk.getStorageId() == null);
			}
			if (this.accountResourceId != null) {
				eq = eq
						&& this.accountResourceId.equals(pk
								.getAccountResourceId());
			} else // this.cloudAccountId == null
			{
				eq = eq && (pk.getAccountResourceId() == null);
			}
			if (this.region != null) {
				eq = eq && this.region.equals(pk.getRegion());
			} else // this.region == null
			{
				eq = eq && (pk.getRegion() == null);
			}

			return eq;
		}

		public String toString() {
			StringBuffer toStringValue = new StringBuffer("[.");
			toStringValue.append(this.storageId).append('.');
			toStringValue.append(this.accountResourceId).append('.');
			toStringValue.append(this.region).append('.');
			toStringValue.append(']');
			return toStringValue.toString();
		}
	}
	
	
	private String storageId;
	private String cloudServiceId;
	private String region;
	private String accountResourceId;
	private String storageName;
	private String zone;
	private String flavor;
	private String facilityId;
	private Integer deviceIndex;
	private String deviceType;
	private String deviceName;
	private StorageStatus registStatus;

	public CloudStorageDao()
	{
	}

	public CloudStorageDao( String storageId,String cloudServiceId,String accountResourceId,String storageName,String storageType,String cloudId,String cloudUserId,String facilityId,java.lang.Integer deviceIndex,String deviceType,String deviceName,String region,String availabilityZone,StorageStatus registStatus,Timestamp regDate,Timestamp updateDate,String regUser,String updateUser )
	{
		super(regDate, updateDate, regUser, updateUser);
		setStorageId(storageId);
		setCloudServiceId(cloudServiceId);
		setRegion(region);
		setAccountResourceId(accountResourceId);
		setStorageName(storageName);
		setFacilityId(facilityId);
		setDeviceIndex(deviceIndex);
		setDeviceType(deviceType);
		setDeviceName(deviceName);
		setZone(availabilityZone);
		setRegistStatus(registStatus);
	}

	public CloudStorageDao( CloudStorageDao otherData )
	{
		super(otherData);
		setStorageId(otherData.getStorageId());
		setCloudServiceId(otherData.getCloudServiceId());
		setRegion(otherData.getRegion());
		setAccountResourceId(otherData.getAccountResourceId());
		setStorageName(otherData.getStorageName());
		setFacilityId(otherData.getFacilityId());
		setDeviceIndex(otherData.getDeviceIndex());
		setDeviceType(otherData.getDeviceType());
		setDeviceName(otherData.getDeviceName());
		setZone(otherData.getZone());
		setRegistStatus(otherData.getRegistStatus());
	}

	@Id
	@Column(name="storage_id")
	public String getStorageId() {
		return storageId;
	}

	public void setStorageId(String storageId) {
		this.storageId = storageId;
	}

	@Column(name="cloud_Service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}
	
	@Id
	@Column(name="region")
	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}
	
	@Id
	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}

	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}
	
	@Column(name="storage_name")
	public String getStorageName()
	{
		return this.storageName;
	}
	public void setStorageName( String storageName )
	{
		this.storageName = storageName;
	}

	@Column(name="flavor")
	public String getFlavor() {
		return flavor;
	}

	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}

	@Column(name="facility_id")
	public String getFacilityId()
	{
		return this.facilityId;
	}
	public void setFacilityId( String facilityId )
	{
		this.facilityId = facilityId;
	}

	@Column(name="device_index")
	public java.lang.Integer getDeviceIndex()
	{
		return this.deviceIndex;
	}
	public void setDeviceIndex( java.lang.Integer deviceIndex )
	{
		this.deviceIndex = deviceIndex;
	}

	@Column(name="device_type")
	public String getDeviceType()
	{
		return this.deviceType;
	}
	public void setDeviceType( String deviceType )
	{
		this.deviceType = deviceType;
	}

	@Column(name="device_name")
	public String getDeviceName()
	{
		return this.deviceName;
	}
	public void setDeviceName( String deviceName )
	{
		this.deviceName = deviceName;
	}

	@Column(name="availability_zone")
	public String getZone()
	{
		return this.zone;
	}
	public void setZone( String zone )
	{
		this.zone = zone;
	}

	@Column(name="regist_status")
	@Enumerated(EnumType.STRING)
	public StorageStatus getRegistStatus()
	{
		return this.registStatus;
	}
	public void setRegistStatus( StorageStatus registStatus )
	{
		this.registStatus = registStatus;
	}

	@Override
	public String toString() {
		return "CloudStorageDao [storageId=" + storageId + ", cloudServiceId="
				+ cloudServiceId + ", region=" + region
				+ ", accountResourceId=" + accountResourceId + ", storageName="
				+ storageName + ", zone=" + zone + ", flavor=" + flavor
				+ ", facilityId=" + facilityId + ", deviceIndex=" + deviceIndex
				+ ", deviceType=" + deviceType + ", deviceName=" + deviceName
				+ ", registStatus=" + registStatus + ", "
				+ super.toString() + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudStorageDao other = (CloudStorageDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (cloudServiceId == null) {
			if (other.cloudServiceId != null)
				return false;
		} else if (!cloudServiceId.equals(other.cloudServiceId))
			return false;
		if (deviceIndex == null) {
			if (other.deviceIndex != null)
				return false;
		} else if (!deviceIndex.equals(other.deviceIndex))
			return false;
		if (deviceName == null) {
			if (other.deviceName != null)
				return false;
		} else if (!deviceName.equals(other.deviceName))
			return false;
		if (deviceType == null) {
			if (other.deviceType != null)
				return false;
		} else if (!deviceType.equals(other.deviceType))
			return false;
		if (facilityId == null) {
			if (other.facilityId != null)
				return false;
		} else if (!facilityId.equals(other.facilityId))
			return false;
		if (flavor == null) {
			if (other.flavor != null)
				return false;
		} else if (!flavor.equals(other.flavor))
			return false;
		if (region == null) {
			if (other.region != null)
				return false;
		} else if (!region.equals(other.region))
			return false;
		if (registStatus != other.registStatus)
			return false;
		if (storageId == null) {
			if (other.storageId != null)
				return false;
		} else if (!storageId.equals(other.storageId))
			return false;
		if (storageName == null) {
			if (other.storageName != null)
				return false;
		} else if (!storageName.equals(other.storageName))
			return false;
		if (zone == null) {
			if (other.zone != null)
				return false;
		} else if (!zone.equals(other.zone))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((cloudServiceId == null) ? 0 : cloudServiceId.hashCode());
		result = prime * result
				+ ((deviceIndex == null) ? 0 : deviceIndex.hashCode());
		result = prime * result
				+ ((deviceName == null) ? 0 : deviceName.hashCode());
		result = prime * result
				+ ((deviceType == null) ? 0 : deviceType.hashCode());
		result = prime * result
				+ ((facilityId == null) ? 0 : facilityId.hashCode());
		result = prime * result + ((flavor == null) ? 0 : flavor.hashCode());
		result = prime * result + ((region == null) ? 0 : region.hashCode());
		result = prime * result
				+ ((registStatus == null) ? 0 : registStatus.hashCode());
		result = prime * result
				+ ((storageId == null) ? 0 : storageId.hashCode());
		result = prime * result
				+ ((storageName == null) ? 0 : storageName.hashCode());
		result = prime * result + ((zone == null) ? 0 : zone.hashCode());
		return result;
	}
	
	@Override
	public CloudStorageDao.CloudStoragePK getId() {
		return new CloudStorageDao.CloudStoragePK(getStorageId(), getRegion(), getAccountResourceId());
	}
}
