/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_instance")
@IdClass(CloudInstanceDao.CloudInstancePK.class)
public class CloudInstanceDao extends HinemosObjectDao {
	public static enum InstanceStatus {
		registered,
		unregistered,
		deleted
	}
	
	public static class CloudInstancePK extends Object implements java.io.Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 682905935857533293L;

		private String instanceId;
		private String accountResourceId;
		private String region;

		public CloudInstancePK() {
		}

		public CloudInstancePK(String instanceId, String region, String accountResourceId) {
			this.instanceId = instanceId;
			this.accountResourceId = accountResourceId;
			this.region = region;
		}

		public String getInstanceId() {
			return instanceId;
		}
		public void setInstanceId(String instanceId) {
			this.instanceId = instanceId;
		}

		public String getAccountResourceId() {
			return accountResourceId;
		}
		public void setAccountResourceId(String AccountResourceId) {
			this.accountResourceId = AccountResourceId;
		}

		public String getRegion()
		{
			return this.region;
		}
		public void setRegion(String region)
		{
			this.region = region;
		}

		public int hashCode() {
			int _hashCode = 0;
			if (this.instanceId != null)
				_hashCode += this.instanceId.hashCode();
			if (this.accountResourceId != null)
				_hashCode += this.accountResourceId.hashCode();
			if (this.region != null)
				_hashCode += this.region.hashCode();

			return _hashCode;
		}

		public boolean equals(Object obj) {
			if (!(obj instanceof CloudInstancePK))
				return false;

			CloudInstancePK pk = (CloudInstancePK) obj;
			boolean eq = true;

			if (this.instanceId != null) {
				eq = eq && this.instanceId.equals(pk.getInstanceId());
			} else
			{
				eq = eq && (pk.getInstanceId() == null);
			}
			if (this.accountResourceId != null) {
				eq = eq
						&& this.accountResourceId.equals(pk
								.getAccountResourceId());
			} else
			{
				eq = eq && (pk.getAccountResourceId() == null);
			}
			if (this.region != null) {
				eq = eq && this.region.equals(pk.getRegion());
			} else
			{
				eq = eq && (pk.getRegion() == null);
			}

			return eq;
		}

		public String toString() {
			StringBuffer toStringValue = new StringBuffer("[.");
			toStringValue.append(this.instanceId).append('.');
			toStringValue.append(this.accountResourceId).append('.');
			toStringValue.append(this.region).append('.');
			toStringValue.append(']');
			return toStringValue.toString();
		}
	}
	
	private String instanceId;
	private String cloudServiceId;
	private String region;
	private String accountResourceId;
	private String instanceName;
	private String facilityId;
	private String zone;
	private String cloudUserId;
	private InstanceStatus registStatus;
	private String templateId;

	public CloudInstanceDao()
	{
	}

	public CloudInstanceDao( String instanceId,String cloudServiceId,String accountResourceId,String region,String instanceName,String facilityId,String zone,String cloudId,String cloudUserId,InstanceStatus registStatus,String templateId,Timestamp regDate,Timestamp updateDate,String regUser,String updateUser )
	{
		super(regDate, updateDate, regUser, updateUser);
		setInstanceId(instanceId);
		setCloudServiceId(cloudServiceId);
		setRegion(region);
		setAccountResourceId(accountResourceId);
		setInstanceName(instanceName);
		setFacilityId(facilityId);
		setZone(zone);
		setCloudUserId(cloudUserId);
		setRegistStatus(registStatus);
		setTemplateId(templateId);
	}

	public CloudInstanceDao( CloudInstanceDao otherData )
	{
		super(otherData);
		setInstanceId(otherData.getInstanceId());
		setCloudServiceId(otherData.getCloudServiceId());
		setRegion(otherData.getRegion());
		setAccountResourceId(otherData.getAccountResourceId());
		setInstanceName(otherData.getInstanceName());
		setFacilityId(otherData.getFacilityId());
		setZone(otherData.getZone());
		setCloudUserId(otherData.getCloudUserId());
		setRegistStatus(otherData.getRegistStatus());
		setTemplateId(otherData.getTemplateId());
	}

	@Id
	@Column(name="instance_id")
	public String getInstanceId() {
		return instanceId;
	}
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	@Column(name="cloud_Service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}
	
	@Id
	@Column(name="region")
	public String getRegion()
	{
		return this.region;
	}
	public void setRegion(String region)
	{
		this.region = region;
	}

	@Id
	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String AccountResourceId) {
		this.accountResourceId = AccountResourceId;
	}

	@Column(name="instance_name")
	public String getInstanceName()
	{
		return this.instanceName;
	}
	public void setInstanceName( String instanceName )
	{
		this.instanceName = instanceName;
	}

	@Column(name="facility_id", unique=true)
	public String getFacilityId()
	{
		return this.facilityId;
	}
	public void setFacilityId( String facilityId )
	{
		this.facilityId = facilityId;
	}

	@Column(name="availavility_zone")
	public String getZone()
	{
		return this.zone;
	}
	public void setZone( String zone )
	{
		this.zone = zone;
	}

	@Column(name="cloud_user_id")
	public String getCloudUserId()
	{
		return this.cloudUserId;
	}
	public void setCloudUserId( String cloudUserId )
	{
		this.cloudUserId = cloudUserId;
	}

	@Column(name="regist_status")
	@Enumerated(EnumType.STRING)
	public InstanceStatus getRegistStatus()
	{
		return this.registStatus;
	}
	public void setRegistStatus( InstanceStatus registStatus )
	{
		this.registStatus = registStatus;
	}

	@Column(name="template_id")
	public String getTemplateId()
	{
		return this.templateId;
	}
	public void setTemplateId( String templateId )
	{
		this.templateId = templateId;
	}

	@Override
	public String toString() {
		return "CloudInstanceDao [instanceId=" + instanceId
				+ ", cloudServiceId=" + cloudServiceId + ", region=" + region
				+ ", accountResourceId=" + accountResourceId
				+ ", instanceName=" + instanceName + ", facilityId="
				+ facilityId + ", zone=" + zone + ", cloudUserId="
				+ cloudUserId + ", registStatus=" + registStatus
				+ ", templateId=" + templateId + ", "
				+ super.toString() + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudInstanceDao other = (CloudInstanceDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (cloudServiceId == null) {
			if (other.cloudServiceId != null)
				return false;
		} else if (!cloudServiceId.equals(other.cloudServiceId))
			return false;
		if (cloudUserId == null) {
			if (other.cloudUserId != null)
				return false;
		} else if (!cloudUserId.equals(other.cloudUserId))
			return false;
		if (facilityId == null) {
			if (other.facilityId != null)
				return false;
		} else if (!facilityId.equals(other.facilityId))
			return false;
		if (instanceId == null) {
			if (other.instanceId != null)
				return false;
		} else if (!instanceId.equals(other.instanceId))
			return false;
		if (instanceName == null) {
			if (other.instanceName != null)
				return false;
		} else if (!instanceName.equals(other.instanceName))
			return false;
		if (region == null) {
			if (other.region != null)
				return false;
		} else if (!region.equals(other.region))
			return false;
		if (registStatus != other.registStatus)
			return false;
		if (templateId == null) {
			if (other.templateId != null)
				return false;
		} else if (!templateId.equals(other.templateId))
			return false;
		if (zone == null) {
			if (other.zone != null)
				return false;
		} else if (!zone.equals(other.zone))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((cloudServiceId == null) ? 0 : cloudServiceId.hashCode());
		result = prime * result
				+ ((cloudUserId == null) ? 0 : cloudUserId.hashCode());
		result = prime * result
				+ ((facilityId == null) ? 0 : facilityId.hashCode());
		result = prime * result
				+ ((instanceId == null) ? 0 : instanceId.hashCode());
		result = prime * result
				+ ((instanceName == null) ? 0 : instanceName.hashCode());
		result = prime * result + ((region == null) ? 0 : region.hashCode());
		result = prime * result
				+ ((registStatus == null) ? 0 : registStatus.hashCode());
		result = prime * result
				+ ((templateId == null) ? 0 : templateId.hashCode());
		result = prime * result + ((zone == null) ? 0 : zone.hashCode());
		return result;
	}

	@Override
	public CloudInstanceDao.CloudInstancePK getId() {
		return new CloudInstanceDao.CloudInstancePK(getInstanceId(), getRegion(), getAccountResourceId());
	}
}
