/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;

/**
 * インスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(CreateInstanceRequest request) addInstance 関数} にて使用される。
 *
 */
public class CreateInstanceRequest extends CloudRequest {
	private NodeDetail nodeDetail;

	private String flavor;
	private String imageId;
	private String zone;
	private String instanceDetail;
	private List<Tag> tags = new ArrayList<Tag>();


	public CreateInstanceRequest() {
	}	

	/**
	 * ノード作成に必要な情報を返す。
	 * 
	 * @return ノード作成情報。
	 */
	@ElementId("NodeDetail")
	@NotNull
	@Into
	public NodeDetail getNodeDetail() {
		return nodeDetail;
	}

	/**
	 * ノード作成情報を指定する。
	 * この値は、{@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(CreateInstanceRequest request) addInstance 関数} を実行する際、必須となります。
	 * 
	 * @param nodeDetail ノード作成情報。
	 */
	public void setNodeDetail(NodeDetail nodeDetail) {
		this.nodeDetail = nodeDetail;
	}

	public String getFlavor() {
		return flavor;
	}
	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}
	
	/**
	 * EC2 インスタンスに適用するイメージ ID を取得する。
	 * 
	 * @return AMI ID
	 */
	@ElementId("imageId")
	@NotNull
	public String getImageId() {
		return imageId;
	}

	/**
	 * EC2 インスタンスに適用するイメージ ID を指定する。
	 * この値は、128 文字以内となります。
	 * 
	 * @param imageId AMI ID
	 */
	public void setImageId(String imageId) {
		this.imageId = imageId;
	}

	public String getZone() {
		return zone;
	}
	public void setZone(String zone) {
		this.zone = zone;
	}

	public String getInstanceDetail() {
		return instanceDetail;
	}
	public void setInstanceDetail(String instanceDetail) {
		this.instanceDetail = instanceDetail;
	}

	@ElementId("tags")
	@NotNull
//	@ListElement
	public List<Tag> getTags() {
		return tags;
	}
	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}
}