/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.dao.CloudInstanceDao;
import com.clustercontrol.cloud.validation.annotation.Size;

public class CloudInstance implements Serializable, ICloudResource {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2744959762926787150L;

	private CloudInstanceDao dao;
	private String facilityName;
	private String platform;
	private String imageId;
	private String cloudTypeId;
	private InstanceStateKind state;
	private String flavor;
//	private long launchTime;
	private List<Tag> tags = new ArrayList<>();
	private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<>();
	
	IResourceManagement.Instance instance;
	
	public CloudInstance() {
		super();
		this.dao = new CloudInstanceDao();
	}

	public CloudInstance(CloudInstanceDao dao, String cloudTypeId, String facilityName) {
		super();
		this.dao = dao;
		this.facilityName = facilityName;
		this.cloudTypeId = cloudTypeId;
	}

	public CloudInstance(CloudInstanceDao tableData, String cloudTypeId, IResourceManagement.Instance instance, String facilityName) {
		this(tableData, cloudTypeId, facilityName);

		this.instance = instance;
		
		this.platform = instance.getPlatform().label();
		this.imageId = instance.getImageId();
		this.state = InstanceStateKind.byLabel(instance.getState().name());
		this.flavor = instance.getFlavor();
		this.imageId = instance.getImageId();
//		this.launchTime = instance.getLaunchTime().getTime();
		for (Tag t: instance.getTags()) {
			Tag tag = new Tag(t.getKey(), t.getValue());
			this.tags.add(tag);
		}
		for (IResourceManagement.Instance.BlockDeviceMapping d: instance.getBlockDeviceMappings()) {
			BlockDeviceMapping device = new BlockDeviceMapping(
					d.getStorageId(), d.getDeviceName(), d.getStatus());
			this.blockDeviceMappings.add(device);
		}
	}

	public String getFacilityId() {
		return dao.getFacilityId();
	}

	public void setFacilityId(String facilityId) {
		throw new UnsupportedOperationException();
	}

	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		throw new UnsupportedOperationException();
	}

	public String getInstanceId() {
		return dao.getInstanceId();
	}
	public void setInstanceId(String instanceId) {
		throw new UnsupportedOperationException();
	}

	public String getPlatform() {
		return platform;
	}
	public void setPlatform(String platform) {
		throw new UnsupportedOperationException();
	}
	
	public String getAccountResourceId() {
		return dao.getAccountResourceId();
	}
	public void setAccountResourceId(String accountResourceId) {
	}

	public String getRegion() {
		return dao.getRegion();
	}
	public void setRegion(String region) {
		throw new UnsupportedOperationException();
	}

	public String getZone() {
		return dao.getZone();
	}
	public void setZone(String zone) {
		throw new UnsupportedOperationException();
	}

	public String getImageId() {
		return imageId;
	}
	public void setImageId(String imageId) {
		throw new UnsupportedOperationException();
	}
	
	@Size(elementId = "cloudInstance.templateId", max = 64)
	public String getTemplateId() {
		return dao.getTemplateId();
	}
	public void setTemplateId(String templateId) {
		throw new UnsupportedOperationException();
	}
	
	public InstanceStateKind getState() {
		return state;
	}
	public void setState(InstanceStateKind state) {
		throw new UnsupportedOperationException();
	}

	public InstanceRegistStateType getRegistState() {
		if (dao.getRegistStatus() == null) {
			return null;
		}
		return InstanceRegistStateType.valueOf(dao.getRegistStatus().name());
	}
	public void setRegistState(InstanceRegistStateType registState) {
		throw new UnsupportedOperationException();
	}
	
	public String getFlavor() {
		return flavor;
	}
	public void setFlavor(String flavor) {
		throw new UnsupportedOperationException();
	}
	
	public List<Tag> getTags() {
		return tags;
	}
	public void setTags(List<Tag> tags) {
		throw new UnsupportedOperationException();
	}
	
	public String getInstanceName() {
		return dao.getInstanceName();
	}
	public void setInstanceName(String instanceName) {
		throw new UnsupportedOperationException();
	}

	public String getCloudUserId() {
		return dao.getCloudUserId();
	}
	public void setCloudUserId(String cloudUserId) {
		throw new UnsupportedOperationException();
	}
	
	public List<BlockDeviceMapping> getBlockDeviceMappings() {
		return blockDeviceMappings;
	}
	public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
		throw new UnsupportedOperationException();
	}

	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}
	public void setRegDate(Long regDate) {
		throw new UnsupportedOperationException();
	}

	public Long getUpdateDate() {
		return dao.getUpdateDate() != null ? dao.getUpdateDate().getTime(): null;
	}
	public void setUpdateDate(Long updateDate) {
		throw new UnsupportedOperationException();
	}

	public String getRegUser() {
		return dao.getRegUser();
	}
	public void setRegUser(String regUser) {
		throw new UnsupportedOperationException();
	}

	public String getUpdateUser() {
		return dao.getUpdateUser();
	}
	public void setUpdateUser(String updateUser) {
		throw new UnsupportedOperationException();
	}

	public String getCloudTypeId() {
		return cloudTypeId;
	}
	public void setCloudTypeId(String cloudTypeId) {
		throw new UnsupportedOperationException();
	}

	@XmlTransient
	public IResourceManagement.Instance getResource() {
		return instance;
	}
}
